/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql.metadata.jdbc;

import java.sql.DatabaseMetaData;
import java.util.List;
import java.util.Map;
import org.nkjmlab.sorm4j.internal.sql.metadata.jdbc.JdbcDatabaseMetaDataImpl;
import org.nkjmlab.sorm4j.internal.util.CanonicalStringCache;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcColumnMetaData;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcForeignKeyMetaData;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcIndexMetaData;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcTableMetaData;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public interface JdbcDatabaseMetaData {
    public String getDatabaseProductName();

    public String getDatabaseProductVersion();

    public int getDefaultTransactionIsolation();

    public String getDriverName();

    public String getDriverVersion();

    public Map<TableName, List<JdbcForeignKeyMetaData>> getJdbcForeignKeysMetaData();

    public Map<TableName, List<JdbcColumnMetaData>> getJdbcColumnsMetaData();

    public Map<TableName, Map<String, JdbcIndexMetaData>> getJdbcIndexesMetaData();

    public int getJdbcMajorVersion();

    public int getJdbcMinorVersion();

    public Map<TableName, JdbcTableMetaData> getJdbcTablesMetaData();

    public int getMaxConnections();

    public String getNumericFunctions();

    public Map<TableName, List<String>> getPrimaryKeysMetaData();

    public Map<String, String> getSchemasMetaData();

    public String getSearchStringEscape();

    public String getSqlKeywords();

    public String getStringFunctions();

    public String getSystemFunctions();

    public List<TableName> getTableNames();

    public String getTimeDateFunctions();

    public String getUrl();

    public String getUserName();

    public boolean isSupportsBatchUpdates();

    public boolean isSupportsStoredProcedures();

    public boolean isSupportsTransactions();

    public static JdbcDatabaseMetaData of(DatabaseMetaData metaData) {
        return Try.getOrElseThrow(() -> JdbcDatabaseMetaDataImpl.of(metaData), e -> Try.rethrow(e));
    }

    public static final class TableName
    implements Comparable<TableName> {
        private final String name;

        private TableName(String name) {
            this.name = CanonicalStringCache.getDefault().toCanonicalName(name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TableName)) {
                return false;
            }
            TableName other = (TableName)obj;
            return this.name.equals(other.name);
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        public static TableName of(String tableName) {
            return new TableName(tableName);
        }

        @Override
        public int compareTo(TableName other) {
            return this.name.compareTo(other.name);
        }
    }
}

