/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql.statement;

import java.util.List;
import org.nkjmlab.sorm4j.sql.statement.SelectSql;
import org.nkjmlab.sorm4j.sql.statement.SqlKeyword;
import org.nkjmlab.sorm4j.sql.statement.SqlStringUtils;

public class ConditionSql {
    private final Object condition;

    private ConditionSql(Object expr) {
        this.condition = expr;
    }

    private ConditionSql(String op, Object ... conds) {
        this(SelectSql.wrapParentheses(SqlStringUtils.join(SelectSql.wrapSpace(op), conds)));
    }

    private ConditionSql(Object left, String op, Object right) {
        this.condition = String.valueOf(left) + " " + op.trim() + " " + String.valueOf(right);
    }

    public static ConditionSql cond(String cond) {
        return new ConditionSql(cond);
    }

    public static ConditionSql cond(Object left, String operator, Object right) {
        return new ConditionSql(left, operator, right);
    }

    public static ConditionSql and(Object ... conds) {
        return new ConditionSql("and", conds);
    }

    public static ConditionSql or(Object ... conds) {
        return new ConditionSql("or", conds);
    }

    public static ConditionSql between(Object colName, Object startInclusive, Object endInclusive) {
        return new ConditionSql(SelectSql.wrapSpace(String.valueOf(colName) + SqlKeyword.BETWEEN + SqlStringUtils.literal(startInclusive) + SqlKeyword.AND + SqlStringUtils.literal(endInclusive)));
    }

    public static ConditionSql in(Object colName, List<?> values) {
        return new ConditionSql(SelectSql.wrapSpace(String.valueOf(colName) + SqlKeyword.IN + SelectSql.wrapParentheses(SqlStringUtils.literal(values))));
    }

    public String toString() {
        return this.condition.toString();
    }
}

