/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql.statement;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SqlStringUtils {
    private SqlStringUtils() {
    }

    public static String literal(Object element) {
        if (element == null) {
            return "null";
        }
        if (element.getClass().isArray()) {
            int length = Array.getLength(element);
            ArrayList<String> ret = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                ret.add(SqlStringUtils.literal(Array.get(element, i)));
            }
            return "array [" + String.join((CharSequence)", ", ret) + "]";
        }
        if (element instanceof List) {
            return String.join((CharSequence)", ", (CharSequence[])((List)element).stream().map(e -> SqlStringUtils.literal(e)).toArray(String[]::new));
        }
        String str = element.toString();
        if (element instanceof Number || element instanceof Boolean) {
            return str;
        }
        switch (str) {
            case "?": {
                return str;
            }
        }
        return SqlStringUtils.quote(str);
    }

    public static String quote(String str) {
        return str == null ? null : "'" + str.replaceAll("'", "''") + "'";
    }

    public static String join(String delimiter, Object ... elements) {
        return Arrays.stream(elements).map(o -> Objects.toString(o, "null")).collect(Collectors.joining(delimiter));
    }

    public static String join(String delimiter, String[] elements) {
        return SqlStringUtils.join(delimiter, (Object[])elements);
    }

    public static String escapeJavaString(String str) {
        return str == null ? null : str.replace("\\", "\\\\").replace("\b", "\\b").replace("\t", "\\t").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("'", "\\'").replace("\"", "\\\"");
    }
}

