/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.table.definition;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.extension.datatype.jackson.annotation.OrmJacksonColumn;
import org.nkjmlab.sorm4j.internal.sql.result.TableDefinitionImpl;
import org.nkjmlab.sorm4j.internal.util.ArrayUtils;
import org.nkjmlab.sorm4j.internal.util.reflection.ReflectionConstrucorsUtils;
import org.nkjmlab.sorm4j.internal.util.reflection.RefrectionOrmComponentUtils;
import org.nkjmlab.sorm4j.internal.util.reflection.RefrectionTableNameUtils;
import org.nkjmlab.sorm4j.table.definition.annotation.AutoIncrement;
import org.nkjmlab.sorm4j.table.definition.annotation.Check;
import org.nkjmlab.sorm4j.table.definition.annotation.Default;
import org.nkjmlab.sorm4j.table.definition.annotation.Index;
import org.nkjmlab.sorm4j.table.definition.annotation.IndexColumnPair;
import org.nkjmlab.sorm4j.table.definition.annotation.NotNull;
import org.nkjmlab.sorm4j.table.definition.annotation.PrimaryKey;
import org.nkjmlab.sorm4j.table.definition.annotation.PrimaryKeyConstraint;
import org.nkjmlab.sorm4j.table.definition.annotation.Unique;
import org.nkjmlab.sorm4j.table.definition.annotation.UniqueConstraint;

public interface TableDefinition {
    public TableDefinition createIndexesIfNotExists(Orm var1);

    public TableDefinition createTableIfNotExists(Orm var1);

    public TableDefinition dropTableIfExists(Orm var1);

    public void dropTableIfExistsCascade(Orm var1);

    public List<String> getColumnNames();

    public List<String> getCreateIndexIfNotExistsStatements();

    public String getCreateTableIfNotExistsStatement();

    public String getDropTableIfExistsStatement();

    public String getTableName();

    public String getTableNameAndColumnDefinitions();

    public static String toSqlDataType(Class<?> type) {
        if (type.getAnnotation(OrmJacksonColumn.class) != null) {
            return "json";
        }
        if (ArrayUtils.getInternalComponentType(type).getAnnotation(OrmJacksonColumn.class) != null) {
            return "json";
        }
        switch (type.getName()) {
            case "int": 
            case "java.lang.Integer": {
                return "integer";
            }
            case "double": 
            case "java.lang.Double": {
                return "double";
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "byte": 
            case "java.lang.Byte": {
                return "tinyint";
            }
            case "short": 
            case "java.lang.Short": {
                return "smallint";
            }
            case "long": 
            case "java.lang.Long": {
                return "bigint";
            }
            case "float": 
            case "java.lang.Float": {
                return "float";
            }
            case "char": 
            case "java.lang.Character": {
                return "character";
            }
            case "java.lang.String": {
                return "varchar";
            }
            case "java.math.BigDecimal": {
                return "numeric";
            }
            case "java.sql.Timestamp": 
            case "java.time.Instant": 
            case "java.time.LocalDateTime": {
                return "timestamp";
            }
            case "java.sql.Time": 
            case "java.time.LocalTime": {
                return "time";
            }
            case "java.sql.Date": 
            case "java.time.LocalDate": {
                return "date";
            }
            case "java.time.OffsetTime": {
                return "time with time zone";
            }
            case "java.time.OffsetDateTime": {
                return "timestamp with time zone";
            }
            case "java.sql.Blob": {
                return "blob";
            }
            case "java.sql.Clob": {
                return "clob";
            }
            case "java.io.InputStream": {
                return "longvarbinary";
            }
            case "java.io.Reader": {
                return "longvarchar";
            }
            case "org.nkjmlab.sorm4j.extension.datatype.container.GeometryText": 
            case "org.nkjmlab.sorm4j.extension.datatype.jts.JtsGeometry": {
                return "geometry";
            }
            case "org.nkjmlab.sorm4j.extension.datatype.container.JsonByte": 
            case "java.util.List": 
            case "java.util.Map": {
                return "json";
            }
        }
        if (type.isArray()) {
            return TableDefinition.toSqlDataType(type.getComponentType()) + " array";
        }
        if (type.isEnum()) {
            return "varchar";
        }
        return "java_object";
    }

    public static Builder builder(Class<?> valueType, String tableName) {
        Builder builder = TableDefinition.builder(tableName);
        Optional.ofNullable(valueType.getAnnotation(PrimaryKeyConstraint.class)).map(a -> a.value()).ifPresent(val -> builder.setPrimaryKey((String)val));
        Optional.ofNullable((IndexColumnPair[])valueType.getAnnotationsByType(IndexColumnPair.class)).ifPresent(vals -> Arrays.stream(vals).forEach(v -> builder.addIndexDefinition(v.value())));
        Optional.ofNullable((UniqueConstraint[])valueType.getAnnotationsByType(UniqueConstraint.class)).ifPresent(vals -> Arrays.stream(vals).forEach(v -> builder.addUniqueConstraint(v.value())));
        Optional.ofNullable((Check[])valueType.getAnnotationsByType(Check.class)).ifPresent(vals -> Arrays.stream(vals).forEach(v -> builder.addCheckConstraint(v.value())));
        List<ColumnComponent> columnDefinitions = TableDefinition.toColumnDefinition(valueType);
        columnDefinitions.stream().forEach(columnDefinition -> TableDefinition.addColumnDefinition(builder, columnDefinition));
        return builder;
    }

    public static void addColumnDefinition(Builder builder, ColumnComponent columnDefinitionBase) {
        String columnName = SormContext.getDefaultCanonicalStringCache().toCanonicalName(columnDefinitionBase.componentName());
        builder.addColumnDefinition(columnName, TableDefinition.toDataTypeAndOptions(builder, columnName, columnDefinitionBase));
    }

    public static List<ColumnComponent> toColumnDefinition(Class<?> valueType) {
        ArrayList<ColumnComponent> ret = new ArrayList<ColumnComponent>();
        Annotation[][] constructorParameterAnnotations = ReflectionConstrucorsUtils.getRecordCanonicalConstructor(valueType).map(constructor -> constructor.getParameterAnnotations()).orElse(null);
        List<RefrectionOrmComponentUtils.OrmContainerComponent> ormComponents = RefrectionOrmComponentUtils.getOrmComponents(valueType);
        for (int i = 0; i < ormComponents.size(); ++i) {
            RefrectionOrmComponentUtils.OrmContainerComponent ormComp = ormComponents.get(i);
            Annotation[] fieldAnnotations = ormComp.annotations();
            LinkedHashSet columnAnnotations = new LinkedHashSet();
            Arrays.stream(fieldAnnotations).forEach(ann -> columnAnnotations.add(ann));
            if (constructorParameterAnnotations != null) {
                Annotation[] constructorAnnotations = constructorParameterAnnotations[i];
                Arrays.stream(constructorAnnotations).forEach(ann -> columnAnnotations.add(ann));
            }
            ret.add(new ColumnComponent(ormComp.name(), ormComp.type(), new ArrayList<Annotation>(columnAnnotations)));
        }
        return ret;
    }

    public static String[] toDataTypeAndOptions(Builder builder, String columnName, ColumnComponent columnComponent) {
        ArrayList<Object> opt = new ArrayList<Object>();
        opt.add(TableDefinition.toSqlDataType(columnComponent.componentType()));
        for (Annotation ann : columnComponent.annotations()) {
            if (ann instanceof PrimaryKey) {
                opt.add("primary key");
                continue;
            }
            if (ann instanceof AutoIncrement) {
                opt.add("auto_increment");
                continue;
            }
            if (ann instanceof NotNull) {
                opt.add("not null");
                continue;
            }
            if (ann instanceof Index) {
                builder.addIndexDefinition(columnName);
                continue;
            }
            if (ann instanceof Unique) {
                builder.addUniqueConstraint(columnName);
                continue;
            }
            if (ann instanceof Check) {
                opt.add("check (" + ((Check)ann).value() + ")");
                continue;
            }
            if (!(ann instanceof Default)) continue;
            opt.add("default " + ((Default)ann).value());
        }
        return (String[])opt.toArray(String[]::new);
    }

    public static Builder builder(Class<?> valueType) {
        return TableDefinition.builder(valueType, RefrectionTableNameUtils.toNaiveTableName(valueType));
    }

    public static Builder builder(String tableName) {
        return new Builder(tableName);
    }

    public static class Builder {
        private String tableName;
        private final Map<String, String[]> columnDefinitions = new LinkedHashMap<String, String[]>();
        private String[] primaryKeys;
        private final List<String[]> uniqueColumnPairs = new ArrayList<String[]>();
        private final List<String[]> indexColumns = new ArrayList<String[]>();
        private final List<String> checkConditions = new ArrayList<String>();

        private static String createPrimaryKeyConstraint(String[] primaryKeys) {
            return primaryKeys == null || primaryKeys.length == 0 ? "" : ", primary key(" + String.join((CharSequence)", ", primaryKeys) + ")";
        }

        private static String createUniqueConstraint(List<String[]> uniqueColumnPairs) {
            return uniqueColumnPairs == null || uniqueColumnPairs.size() == 0 ? "" : ", " + String.join((CharSequence)", ", (CharSequence[])uniqueColumnPairs.stream().map(u -> "unique(" + String.join((CharSequence)", ", u) + ")").toArray(String[]::new));
        }

        private static String createCheckConstraint(List<String> checkConditions) {
            return checkConditions == null || checkConditions.size() == 0 ? "" : ", " + String.join((CharSequence)", ", (CharSequence[])checkConditions.stream().map(u -> "check(" + u + ")").toArray(String[]::new));
        }

        private static List<String> getColumunNames(Map<String, String[]> columnDefinitions) {
            return columnDefinitions.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        }

        private static List<String> getColumuns(Map<String, String[]> columnDefinisions) {
            return columnDefinisions.keySet().stream().map(columnName -> columnName + " " + String.join((CharSequence)" ", Arrays.stream((String[])columnDefinisions.get(columnName)).map(s -> s.trim()).collect(Collectors.toList()))).collect(Collectors.toList());
        }

        private static String getCreateIndexOnStatement(String indexName, String tableName, String ... columns) {
            return "create index if not exists " + indexName + " on " + tableName + "(" + String.join((CharSequence)", ", columns) + ")";
        }

        private static String getTableSchema(String tableName, Map<String, String[]> columns, String[] primaryKeys, List<String[]> uniqueColumnPairs, List<String> checkConditions) {
            String schema = tableName + "(" + String.join((CharSequence)", ", Builder.getColumuns(columns)) + Builder.createPrimaryKeyConstraint(primaryKeys) + Builder.createUniqueConstraint(uniqueColumnPairs) + Builder.createCheckConstraint(checkConditions) + ")";
            return schema;
        }

        private static String[] toStringArray(Enum<?>[] enums) {
            return (String[])Arrays.stream(enums).map(e -> e.toString()).toArray(String[]::new);
        }

        Builder(String tableName) {
            this.tableName = tableName;
        }

        public Builder addColumnDefinition(Enum<?> columnName, String ... dataTypeAndOptions) {
            this.addColumnDefinition(columnName.toString(), dataTypeAndOptions);
            return this;
        }

        public Builder addColumnDefinition(String columnName, String ... dataTypeAndOptions) {
            this.columnDefinitions.put(columnName, dataTypeAndOptions);
            return this;
        }

        public Builder addIndexDefinition(Enum<?> ... indexColumnPair) {
            this.addIndexDefinition(Builder.toStringArray(indexColumnPair));
            return this;
        }

        public Builder addIndexDefinition(String ... indexColumnPair) {
            this.indexColumns.add(indexColumnPair);
            return this;
        }

        public Builder addUniqueConstraint(Enum<?> ... uniqueColumnPair) {
            this.uniqueColumnPairs.add(Builder.toStringArray(uniqueColumnPair));
            return this;
        }

        public Builder addUniqueConstraint(String ... uniqueColumnPair) {
            this.uniqueColumnPairs.add(uniqueColumnPair);
            return this;
        }

        public Builder addCheckConstraint(String ... checkConditions) {
            this.checkConditions.addAll(Arrays.asList(checkConditions));
            return this;
        }

        public TableDefinition build() {
            if (this.columnDefinitions.isEmpty()) {
                return new TableDefinitionImpl(this.tableName, "", Collections.emptyList(), "", "", Collections.emptyList());
            }
            String tableSchema = Builder.getTableSchema(this.tableName, this.columnDefinitions, this.primaryKeys, this.uniqueColumnPairs, this.checkConditions);
            String createTableStatement = "create table if not exists " + tableSchema;
            String dropTableStatement = "drop table if exists " + this.tableName;
            return new TableDefinitionImpl(this.tableName, tableSchema, this.getColumunNames(), createTableStatement, dropTableStatement, this.getCreateIndexIfNotExistsStatements());
        }

        private List<String> getColumunNames() {
            return Builder.getColumunNames(this.columnDefinitions);
        }

        private List<String> getCreateIndexIfNotExistsStatements() {
            return this.indexColumns.stream().map(columns -> Builder.getCreateIndexOnStatement("index_in_" + this.tableName + "_on_" + String.join((CharSequence)"_", columns), this.tableName, columns)).collect(Collectors.toList());
        }

        public Builder setPrimaryKey(Enum<?> ... attributes) {
            this.setPrimaryKey(Builder.toStringArray(attributes));
            return this;
        }

        public Builder setPrimaryKey(String ... attributes) {
            this.primaryKeys = attributes;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }
    }

    public record ColumnComponent(String componentName, Class<?> componentType, List<Annotation> annotations) {
    }
}

