/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util.function.exception;

import java.util.function.Consumer;
import java.util.function.Function;
import org.nkjmlab.sorm4j.util.function.exception.TryRunnable;
import org.nkjmlab.sorm4j.util.function.exception.TrySupplier;

public final class Try {
    public static <T> T getOrElse(TrySupplier<T> trySupplier, T other) {
        return (T)TrySupplier.toSupplier(trySupplier, e -> other).get();
    }

    public static <T> T getOrElseGet(TrySupplier<T> trySupplier, Function<Exception, T> otherSupplier) {
        return (T)TrySupplier.toSupplier(trySupplier, e -> otherSupplier.apply((Exception)e)).get();
    }

    public static <T> T getOrElseNull(TrySupplier<T> trySupplier) {
        return (T)TrySupplier.toSupplier(trySupplier, e -> null).get();
    }

    public static <T, X extends RuntimeException> T getOrElseThrow(TrySupplier<T> trySupplier, Function<Exception, ? extends X> exceptionFunction) throws X {
        return (T)TrySupplier.toSupplier(trySupplier, e -> {
            throw (RuntimeException)exceptionFunction.apply((Exception)e);
        }).get();
    }

    public static <T> T getOrElseThrow(TrySupplier<T> trySupplier) {
        return Try.getOrElseThrow(trySupplier, e -> Try.rethrow(e));
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void runOrHandle(TryRunnable tryRunnable, Consumer<Exception> exceptionHandler) {
        TryRunnable.toRunnable(tryRunnable, exceptionHandler).run();
    }

    public static <T, X extends RuntimeException> void runOrThrow(TryRunnable tryRunnable, Function<Exception, ? extends X> exceptionFunction) throws X {
        TryRunnable.toRunnable(tryRunnable, e -> {
            throw (RuntimeException)exceptionFunction.apply((Exception)e);
        }).run();
    }

    public static <T> void runOrThrow(TryRunnable tryRunnable) {
        Try.runOrThrow(tryRunnable, e -> Try.rethrow(e));
    }

    private Try() {
    }
}

