package org.nkjmlab.sorm4j.internal.sql.metadata;

import java.sql.SQLException;
import java.util.List;

import org.nkjmlab.sorm4j.sql.metadata.OrmTableMetaData;

/**
 * An instance of this class contains table metadata.
 *
 * @author yuu_nkjm
 */
public interface TableMetaData extends OrmTableMetaData {

  /**
   * Gets auto generated columns list.
   *
   * @return
   */
  List<String> getAutoGeneratedColumns();

  String[] getAutoGeneratedColumnsArray();

  List<String> getColumnsForUpdate();

  /**
   * Retrieves metadata information for all columns in a specified table.
   *
   * <p>This method queries the database metadata to obtain details about each column in the given
   * table. The metadata includes column name, data type, type name, ordinal position, nullability,
   * auto-increment status, and generated column status.
   *
   * @return a list of {@link ColumnMetaData} objects representing the metadata of all columns in
   *     the specified table.
   * @throws SQLException if a database access error occurs while retrieving column metadata.
   */
  List<ColumnMetaData> getColumnsMetaData();

  List<String> getNotAutoGeneratedColumns();

  List<String> getNotPrimaryKeys();

  List<String> getPrimaryKeys();

  boolean hasAutoGeneratedColumns();

  boolean hasPrimaryKey();
}
