/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.context;

import org.nkjmlab.sorm4j.context.logging.LogContext;
import org.nkjmlab.sorm4j.internal.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.internal.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.internal.mapping.ContainerToTableMapper;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessorFactoryImpl;

public interface MultiRowProcessorFactory {
    public <T> MultiRowProcessor<T> createMultiRowProcessor(LogContext var1, SqlParametersSetter var2, PreparedStatementSupplier var3, Class<T> var4, ContainerToTableMapper<T> var5);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ProcessorType multiRowProcessorType = ProcessorType.MULTI_ROW;
        private int batchSize = 32;
        private int multiRowSize = 32;
        private int batchSizeWithMultiRow = 5;

        public Builder setBatchSize(int size) {
            this.batchSize = size;
            return this;
        }

        public Builder setMultiRowSize(int size) {
            this.multiRowSize = size;
            return this;
        }

        public Builder setBatchSizeWithMultiRow(int size) {
            this.batchSizeWithMultiRow = size;
            return this;
        }

        public Builder setMultiRowProcessorType(ProcessorType type) {
            this.multiRowProcessorType = type;
            return this;
        }

        public MultiRowProcessorFactory build() {
            return new MultiRowProcessorFactoryImpl(this.multiRowProcessorType, this.batchSize, this.multiRowSize, this.batchSizeWithMultiRow);
        }
    }

    public static enum ProcessorType {
        SIMPLE_BATCH,
        MULTI_ROW,
        MULTI_ROW_AND_BATCH;

    }
}

