/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.datatype.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.nkjmlab.sorm4j.context.ColumnValueToJavaObjectConverter;
import org.nkjmlab.sorm4j.extension.datatype.SupportTypes;
import org.nkjmlab.sorm4j.extension.datatype.jackson.JacksonSupportTypes;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public class JacksonColumnValueToJavaObjectConverter
implements ColumnValueToJavaObjectConverter {
    private final ObjectMapper objectMapper;
    private final SupportTypes supportTypes;

    public JacksonColumnValueToJavaObjectConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.supportTypes = new JacksonSupportTypes();
    }

    @Override
    public boolean test(Class<?> toType) {
        return this.supportTypes.isSupport(toType);
    }

    @Override
    public <T> T convertTo(ResultSet resultSet, int columnIndex, int columnType, Class<T> toType) throws SQLException {
        try {
            return (T)this.objectMapper.readValue(resultSet.getBytes(columnIndex), toType);
        }
        catch (IOException e) {
            throw Try.rethrow(e);
        }
    }
}

