/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.datasource;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.nkjmlab.sorm4j.internal.util.SystemPropertyUtils;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public class H2DataSourceFactory {
    private final Config config;
    private final Path databaseDirectoryPath;
    private final Path databaseFilePath;
    private final String inMemoryModeJdbcUrl;
    private final String serverModeJdbcUrl;
    private final String embeddedModeJdbcUrl;
    private final String mixedModeJdbcUrl;

    private H2DataSourceFactory(Config config) {
        this.config = config;
        this.databaseDirectoryPath = H2DataSourceFactory.resolveDatabaseDirectoryPath(config.databaseDirectory());
        Path databasePath = this.databaseDirectoryPath.resolve(config.databaseName()).normalize();
        this.databaseFilePath = Path.of(databasePath.toString() + ".mv.db", new String[0]);
        this.inMemoryModeJdbcUrl = "jdbc:h2:mem:" + config.databaseName() + ";DB_CLOSE_DELAY=-1";
        this.serverModeJdbcUrl = "jdbc:h2:tcp://localhost:" + config.tcpPort() + "/" + String.valueOf(databasePath);
        this.embeddedModeJdbcUrl = "jdbc:h2:file:" + String.valueOf(databasePath);
        this.mixedModeJdbcUrl = "jdbc:h2:" + String.valueOf(databasePath) + ";AUTO_SERVER=TRUE";
    }

    public static H2DataSourceFactory of(Config config) {
        return new H2DataSourceFactory(config);
    }

    private static Path resolveDatabaseDirectoryPath(Path databaseDirectoryPath) {
        Set<String> allowPrefixes = Set.of("~/", "~\\", "./", ".\\", "%TEMP%", "$TMPDIR", "%USERPROFILE%");
        String databaseDirectoryPathStr = databaseDirectoryPath.toString();
        if (!databaseDirectoryPath.isAbsolute() && allowPrefixes.stream().filter(prefix -> databaseDirectoryPathStr.startsWith((String)prefix)).count() == 0L) {
            throw new IllegalArgumentException("the databaseDirectory path should be startWith " + String.valueOf(allowPrefixes) + " or absolute path. The given is [" + String.valueOf(databaseDirectoryPath) + "]");
        }
        return SystemPropertyUtils.convertVariableInPath(databaseDirectoryPath);
    }

    public String toString() {
        return "H2DataSourceFactory [config=" + String.valueOf(this.config) + ", databaseDirectoryPath=" + String.valueOf(this.databaseDirectoryPath) + ", databaseFilePath=" + String.valueOf(this.databaseFilePath) + ", inMemoryModeJdbcUrl=" + this.inMemoryModeJdbcUrl + ", serverModeJdbcUrl=" + this.serverModeJdbcUrl + ", embeddedModeJdbcUrl=" + this.embeddedModeJdbcUrl + ", mixedModeJdbcUrl=" + this.mixedModeJdbcUrl + "]";
    }

    private static String toUrlOption(String[] options) {
        if (options.length == 0) {
            return "";
        }
        return ";" + String.join((CharSequence)";", options);
    }

    public String getInMemoryModeJdbcUrl() {
        return this.getInMemoryModeJdbcUrl(new String[0]);
    }

    public String getServerModeJdbcUrl() {
        return this.getServerModeJdbcUrl(new String[0]);
    }

    public String getEmbeddedModeJdbcUrl() {
        return this.getEmbeddedModeJdbcUrl(new String[0]);
    }

    public String getMixedModeJdbcUrl() {
        return this.getMixedModeJdbcUrl(new String[0]);
    }

    public String getInMemoryModeJdbcUrl(String ... options) {
        return this.inMemoryModeJdbcUrl + H2DataSourceFactory.toUrlOption(options);
    }

    public String getServerModeJdbcUrl(String ... options) {
        return this.serverModeJdbcUrl + H2DataSourceFactory.toUrlOption(options);
    }

    public String getEmbeddedModeJdbcUrl(String ... options) {
        return this.embeddedModeJdbcUrl + H2DataSourceFactory.toUrlOption(options);
    }

    public String getMixedModeJdbcUrl(String ... options) {
        return this.mixedModeJdbcUrl + H2DataSourceFactory.toUrlOption(options);
    }

    public JdbcConnectionPool createInMemoryModeDataSource() {
        return JdbcConnectionPool.create((String)this.getInMemoryModeJdbcUrl(), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createServerModeDataSource() {
        return JdbcConnectionPool.create((String)this.getServerModeJdbcUrl(), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createEmbeddedModeDataSource() {
        return JdbcConnectionPool.create((String)this.getEmbeddedModeJdbcUrl(), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createMixedModeDataSource() {
        return JdbcConnectionPool.create((String)this.getMixedModeJdbcUrl(), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createInMemoryModeDataSource(String ... options) {
        return JdbcConnectionPool.create((String)this.getInMemoryModeJdbcUrl(options), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createServerModeDataSource(String ... options) {
        return JdbcConnectionPool.create((String)this.getServerModeJdbcUrl(options), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createEmbeddedModeDataSource(String ... options) {
        return JdbcConnectionPool.create((String)this.getEmbeddedModeJdbcUrl(options), (String)this.getUsername(), (String)this.getPassword());
    }

    public JdbcConnectionPool createMixedModeDataSource(String ... options) {
        return JdbcConnectionPool.create((String)this.getMixedModeJdbcUrl(options), (String)this.getUsername(), (String)this.getPassword());
    }

    public boolean makeDatabaseFileIfNotExists() {
        boolean bl;
        block10: {
            if (this.getDatabaseFilePath().toFile().exists()) {
                return false;
            }
            if (!this.databaseDirectoryPath.toFile().exists()) {
                this.databaseDirectoryPath.toFile().mkdirs();
            }
            Connection con = DriverManager.getConnection(this.getEmbeddedModeJdbcUrl(), this.getUsername(), this.getPassword());
            try {
                bl = true;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            con.close();
        }
        return bl;
    }

    public Path getDatabaseFilePath() {
        return this.databaseFilePath;
    }

    public String getUsername() {
        return this.config.username();
    }

    public String getPassword() {
        return this.config.password();
    }

    public Path getDatabaseDirectoryPath() {
        return this.databaseDirectoryPath;
    }

    public String getDatabaseName() {
        return this.config.databaseName();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DataSource createTemporalInMemoryDataSource() {
        return JdbcConnectionPool.create((String)("jdbc:h2:mem:" + UUID.randomUUID().toString() + ";DB_CLOSE_DELAY=-1"), (String)"", (String)"");
    }

    public record Config(Path databaseDirectory, String databaseName, String username, String password, int tcpPort) {
        public static Config of(Path databaseDirectory, String databaseName, String username, String password) {
            return new Config(databaseDirectory, databaseName, username, password, 9092);
        }

        public static Config of(Path databaseDirectory, String databaseName, String username, String password, int tcpPort) {
            return new Config(databaseDirectory, databaseName, username, password, tcpPort);
        }

        @Override
        public String toString() {
            return "Config [databaseDirectory=" + String.valueOf(this.databaseDirectory) + ", databaseName=" + this.databaseName + ", username=" + this.username + ", tcpPort=" + this.tcpPort + "]";
        }
    }

    public static class Builder {
        private Path databaseDirectory = Try.getOrElseThrow(() -> Files.createTempDirectory("h2db", new FileAttribute[0]));
        private String databaseName = "sormdb";
        private String username = "";
        private String password = "";
        private int tcpPort = 9092;

        public Builder tcpPort(int tcpPort) {
            this.tcpPort = tcpPort;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder databaseDirectory(Path databaseDirectory) {
            this.databaseDirectory = databaseDirectory;
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public H2DataSourceFactory build() {
            return new H2DataSourceFactory(new Config(this.databaseDirectory, this.databaseName, this.username, this.password, this.tcpPort));
        }
    }
}

