/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.sql.statement;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.extension.h2.functions.table.CsvRead;
import org.nkjmlab.sorm4j.extension.h2.sql.statement.annotation.CsvColumnExpression;
import org.nkjmlab.sorm4j.extension.h2.sql.statement.annotation.CsvIgnore;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.internal.util.reflection.ReflectionConstrucorsUtils;
import org.nkjmlab.sorm4j.internal.util.reflection.RefrectionOrmComponentUtils;
import org.nkjmlab.sorm4j.table.definition.TableDefinition;

public class SelectCsvReadSql {
    private final String sql;

    private SelectCsvReadSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public static Builder builder(CsvRead csvRead) {
        return new Builder(csvRead);
    }

    public static class Builder {
        private List<String> tableColumns = new ArrayList<String>();
        private Map<String, String> aliases = new LinkedHashMap<String, String>();
        private final CsvRead csvRead;

        public Builder(CsvRead csvRead) {
            this.csvRead = csvRead;
        }

        public SelectCsvReadSql build() {
            ArrayList<String> selectedColumns = new ArrayList<String>(this.tableColumns);
            this.aliases.entrySet().forEach(en -> {
                int index = selectedColumns.indexOf(en.getKey());
                if (index == -1) {
                    Object[] params = new Object[]{en.getKey(), this.tableColumns};
                    throw new IllegalStateException(ParameterizedStringFormatter.LENGTH_256.format("{} is not found in Columns {}", params));
                }
                selectedColumns.set(index, (String)en.getValue());
            });
            return new SelectCsvReadSql("select " + (selectedColumns == null || selectedColumns.size() == 0 ? "*" : String.join((CharSequence)", ", selectedColumns)) + " from " + this.csvRead.getSql());
        }

        public Builder mapCsvColumnToTableColumn(String csvColumnExpression, String tableColumn) {
            this.aliases.put(tableColumn, csvColumnExpression + " as " + tableColumn);
            return this;
        }

        public Builder tableColumns(List<String> tableColumns) {
            this.tableColumns = new ArrayList<String>(tableColumns);
            return this;
        }

        public Builder tableColumns(String ... tableColumns) {
            return this.tableColumns(Arrays.asList(tableColumns));
        }

        public Builder valueType(Class<?> valueType) {
            Annotation[][] parameterAnnotationsOfConstructor = ReflectionConstrucorsUtils.getRecordCanonicalConstructor(valueType).map(constructor -> constructor.getParameterAnnotations()).orElse(null);
            List<Field> fields = RefrectionOrmComponentUtils.getDeclaredFields(valueType);
            ArrayList<Field> csvSkipColumns = new ArrayList<Field>();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                ArrayList<String> opt = new ArrayList<String>();
                opt.add(TableDefinition.toSqlDataType(field.getType()));
                LinkedHashSet anns = new LinkedHashSet();
                Arrays.stream(field.getAnnotations()).forEach(a -> anns.add(a));
                if (parameterAnnotationsOfConstructor != null) {
                    Arrays.stream(parameterAnnotationsOfConstructor[i]).forEach(a -> anns.add(a));
                }
                for (Annotation ann : anns) {
                    if (ann instanceof CsvColumnExpression) {
                        this.mapCsvColumnToTableColumn(((CsvColumnExpression)ann).value(), SormContext.getDefaultCanonicalStringCache().toCanonicalName(field.getName()));
                        continue;
                    }
                    if (!(ann instanceof CsvIgnore)) continue;
                    csvSkipColumns.add(field);
                }
            }
            this.tableColumns((String[])fields.stream().map(f -> (csvSkipColumns.contains(f) ? "null as " : "") + SormContext.getDefaultCanonicalStringCache().toCanonicalName(f.getName())).toArray(String[]::new));
            return this;
        }
    }
}

