/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.tools.server.web;

import java.sql.Connection;
import java.util.function.Consumer;
import org.nkjmlab.sorm4j.extension.h2.tools.server.web.H2WebServer;

public class H2WebConsole {
    private H2WebConsole() {
    }

    public static void openBlocking(Connection connection) {
        H2WebConsole.openBlocking(connection, url -> {});
    }

    public static void openBlocking(Connection connection, Consumer<String> urlHandler) {
        H2WebServer server = H2WebConsole.createAndStartServer();
        String url = server.openBrowser(connection);
        urlHandler.accept(url);
        try {
            while (server.isRunning() && !connection.isClosed()) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static H2WebServer createAndStartServer() {
        H2WebServer server = H2WebServer.builder().webPort(0).build();
        server.start();
        return server;
    }

    public static String open(Connection connection) {
        return H2WebConsole.createAndStartServer().openBrowser(connection);
    }
}

