/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.result;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.result.ResultsContainerFactory;

final class ResultsContainerWithSetterFactory<T>
implements ResultsContainerFactory<T> {
    private final Map<List<String>, Class<?>[]> setterTypesMap = new ConcurrentHashMap<List<String>, Class<?>[]>();
    private final Constructor<T> constructor;
    private final ColumnToAccessorMapping columnToAccessorMap;

    public ResultsContainerWithSetterFactory(ColumnToAccessorMapping columnToAccessorMap, Constructor<T> constructor) {
        this.columnToAccessorMap = columnToAccessorMap;
        this.constructor = constructor;
    }

    private Class<?>[] getSetterTypes(String[] columns) {
        return this.setterTypesMap.computeIfAbsent(Arrays.asList(columns), k -> (Class[])Arrays.stream(columns).map(columnName -> Optional.ofNullable(this.columnToAccessorMap.get((String)columnName)).map(acc -> acc.getSetterParameterType()).orElse(null)).toArray(Class[]::new));
    }

    @Override
    public T createContainer(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, OrmConnectionImpl.ColumnsAndTypes columnsAndTypes) throws SQLException {
        Class<?>[] setterTypes = this.getSetterTypes(columnsAndTypes.getColumns());
        return this.createContainerObject(columnValueConverter, resultSet, columnsAndTypes, setterTypes);
    }

    @Override
    public List<T> createContainerList(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, OrmConnectionImpl.ColumnsAndTypes columnsAndTypes) throws SQLException {
        Class<?>[] setterTypes = this.getSetterTypes(columnsAndTypes.getColumns());
        ArrayList<T> ret = new ArrayList<T>();
        while (resultSet.next()) {
            ret.add(this.createContainerObject(columnValueConverter, resultSet, columnsAndTypes, setterTypes));
        }
        return ret;
    }

    private T createContainerObject(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, OrmConnectionImpl.ColumnsAndTypes columnsAndTypes, Class<?>[] setterTypes) {
        try {
            String[] columns = columnsAndTypes.getColumns();
            int[] sqlTypes = columnsAndTypes.getColumnTypes();
            T ret = this.constructor.newInstance(new Object[0]);
            for (int i = 1; i <= columns.length; ++i) {
                Class<?> setterType;
                String columnName = columns[i - 1];
                if (this.columnToAccessorMap.get(columnName) == null || (setterType = setterTypes[i - 1]) == null) continue;
                int sqlType = sqlTypes[i - 1];
                Object value = columnValueConverter.convertTo(resultSet, i, sqlType, setterType);
                this.columnToAccessorMap.setValue(ret, columnName, value);
            }
            return ret;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new SormException("Container class for object relation mapping must have the public default constructor.", e);
        }
    }
}

