/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;

public final class MethodInvokerInfoUtils {
    private MethodInvokerInfoUtils() {
    }

    public static String getInvokerInfo(int depth, StackTraceElement[] stackTraceElements) {
        StackTraceElement e = MethodInvokerInfoUtils.getStackTraceElement(depth, stackTraceElements);
        return e.getClassName() + " (" + (e.getFileName() != null ? new File(e.getFileName()).getName() : "") + ":" + e.getLineNumber() + ") ";
    }

    private static StackTraceElement getStackTraceElement(int index, StackTraceElement[] stackTraceElements) {
        if (index < 0) {
            return stackTraceElements[0];
        }
        if (index >= stackTraceElements.length) {
            return stackTraceElements[stackTraceElements.length - 1];
        }
        return stackTraceElements[index];
    }

    public static String getOutsideInvoker(String libPrefix) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        Optional<StackTraceElement> c = Arrays.stream(stackTrace).filter(s -> !s.getClassName().startsWith(libPrefix) && !s.getClassName().startsWith("java.") && !s.getClassName().startsWith("jdk.")).findFirst();
        if (c.isPresent()) {
            return c.map(se -> MethodInvokerInfoUtils.getInvoker(se)).get();
        }
        c = Arrays.stream(stackTrace).filter(s -> !s.getClassName().startsWith(libPrefix)).findFirst();
        if (c.isPresent()) {
            return c.map(se -> MethodInvokerInfoUtils.getInvoker(se)).get();
        }
        return stackTrace.length == 0 ? "" : MethodInvokerInfoUtils.getInvoker(stackTrace[stackTrace.length - 1]);
    }

    public static String getInvoker(StackTraceElement se) {
        return se.getClassName() + "." + se.getMethodName() + "(" + se.getFileName() + ":" + se.getLineNumber() + ")";
    }
}

