/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql.statement;

import java.util.ArrayList;
import java.util.List;
import org.nkjmlab.sorm4j.sql.metadata.OrmTableMetaData;
import org.nkjmlab.sorm4j.sql.statement.ConditionSql;
import org.nkjmlab.sorm4j.table.orm.TableOrm;

public class JoinSql {
    public static Builder builder(TableOrm<?> firstTable) {
        return new Builder(firstTable);
    }

    public static class Builder {
        private final List<String> columns = new ArrayList<String>();
        private final List<String> froms = new ArrayList<String>();
        private boolean distinct;
        private String where;
        private String orderBy;
        private String limit;

        private Builder(TableOrm<?> firstTable) {
            OrmTableMetaData tableMetaData = firstTable.getOrmTableMetaData();
            this.columns.addAll(tableMetaData.getColumnAliases());
            this.froms.add(tableMetaData.getTableName());
        }

        public Builder distinct() {
            this.distinct = true;
            return this;
        }

        public Builder joinUsing(OrmTableMetaData other, String ... columnsForJoin) {
            return this.joinUsing("join", other, columnsForJoin);
        }

        public Builder joinUsing(TableOrm<?> other, String ... columnsForJoin) {
            return this.joinUsing(other.getOrmTableMetaData(), columnsForJoin);
        }

        public Builder leftJoinUsing(OrmTableMetaData other, String ... columnsForJoin) {
            return this.joinUsing("left join", other, columnsForJoin);
        }

        public Builder leftJoinUsing(TableOrm<?> other, String ... columnsForJoin) {
            return this.leftJoinUsing(other.getOrmTableMetaData(), columnsForJoin);
        }

        public Builder joinOn(OrmTableMetaData other, String onCondition) {
            return this.joinOn("join", other, onCondition);
        }

        public Builder joinOn(TableOrm<?> other, String onCondition) {
            return this.joinOn(other.getOrmTableMetaData(), onCondition);
        }

        public Builder leftJoinOn(OrmTableMetaData other, String onCondition) {
            return this.joinOn("left join", other, onCondition);
        }

        public Builder leftJoinOn(TableOrm<?> other, String onCondition) {
            return this.leftJoinOn(other.getOrmTableMetaData(), onCondition);
        }

        private Builder joinUsing(String joinType, OrmTableMetaData tableMetaData, String ... columnsForJoin) {
            return this.join(joinType, tableMetaData, "using (" + String.join((CharSequence)", ", columnsForJoin) + ")");
        }

        private Builder joinOn(String joinType, OrmTableMetaData tableMetaData, String onCondition) {
            return this.join(joinType, tableMetaData, "on " + onCondition);
        }

        public Builder join(String joinType, OrmTableMetaData otherTableMetaData, String joinCondition) {
            this.columns.addAll(otherTableMetaData.getColumnAliases());
            this.froms.add(String.join((CharSequence)" ", joinType, otherTableMetaData.getTableName(), joinCondition));
            return this;
        }

        public Builder join(String joinType, TableOrm<?> other, String joinCondition) {
            return this.join(joinType, other.getOrmTableMetaData(), joinCondition);
        }

        public Builder where(ConditionSql condition) {
            this.where(condition.toString());
            return this;
        }

        public Builder where(String expr) {
            this.where = expr;
            return this;
        }

        public Builder orderBy(String ... order) {
            this.orderBy = String.join((CharSequence)" ", order);
            return this;
        }

        public Builder limit(int limit) {
            return this.limit(limit, 0);
        }

        public Builder limit(int limit, int offset) {
            this.limit = limit + (String)(offset > 0 ? " offset " + offset : "");
            return this;
        }

        public String build() {
            StringBuilder sql = new StringBuilder("select");
            if (this.distinct) {
                sql.append(" distinct");
            }
            sql.append(" " + String.join((CharSequence)", ", (CharSequence[])this.columns.stream().toArray(String[]::new)));
            sql.append(" from " + String.join((CharSequence)" ", this.froms));
            if (this.where != null) {
                sql.append(" where " + this.where);
            }
            if (this.orderBy != null) {
                sql.append(" order by " + this.orderBy);
            }
            if (this.limit != null) {
                sql.append(" limit " + this.limit);
            }
            return sql.toString();
        }
    }
}

