/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.table.orm;

import java.util.List;
import org.nkjmlab.sorm4j.Orm;
import org.nkjmlab.sorm4j.common.container.RowMap;
import org.nkjmlab.sorm4j.common.container.Tuple;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.mapping.RowMapper;
import org.nkjmlab.sorm4j.sql.metadata.OrmTableMetaData;
import org.nkjmlab.sorm4j.sql.parameterize.ParameterizedSql;
import org.nkjmlab.sorm4j.sql.result.InsertResult;
import org.nkjmlab.sorm4j.sql.result.ResultSetStream;
import org.nkjmlab.sorm4j.sql.statement.SelectSql;
import org.nkjmlab.sorm4j.sql.statement.SqlKeyword;

public interface TableOrm<T> {
    public Orm getOrm();

    public String getTableName();

    public Class<T> getValueType();

    default public T readFirst(ParameterizedSql sql) {
        return this.getOrm().readFirst(this.getValueType(), sql);
    }

    default public T readFirst(String sql, Object ... parameters) {
        return this.getOrm().readFirst(this.getValueType(), sql, parameters);
    }

    default public List<T> readList(ParameterizedSql sql) {
        return this.getOrm().readList(this.getValueType(), sql);
    }

    default public List<T> readList(String sql, Object ... parameters) {
        return this.getOrm().readList(this.getValueType(), sql, parameters);
    }

    default public T readOne(ParameterizedSql sql) {
        return this.getOrm().readOne(this.getValueType(), sql);
    }

    default public T readOne(String sql, Object ... parameters) {
        return this.getOrm().readOne(this.getValueType(), sql, parameters);
    }

    default public RowMapper<T> getRowMapper() {
        return this.getOrm().getRowMapper(this.getValueType());
    }

    default public ResultSetTraverser<List<T>> getResultSetTraverser() {
        return this.getOrm().getResultSetTraverser(this.getValueType());
    }

    default public OrmTableMetaData getOrmTableMetaData() {
        return this.getOrm().getOrmTableMetaData(this.getValueType());
    }

    default public boolean exists(T object) {
        return this.getOrm().exists(object);
    }

    default public boolean exists(Object ... primaryKeyValues) {
        return this.getOrm().existsByPrimaryKey(this.getValueType(), primaryKeyValues);
    }

    default public int[] delete(List<T> objects) {
        return this.getOrm().deleteIn(this.getTableName(), objects);
    }

    default public int delete(T object) {
        return this.getOrm().deleteIn(this.getTableName(), object);
    }

    default public int[] delete(T ... objects) {
        return this.getOrm().deleteIn(this.getTableName(), objects);
    }

    default public int deleteAll() {
        return this.getOrm().deleteAllIn(this.getTableName());
    }

    default public int deleteByPrimaryKey(Object ... primaryKeyValues) {
        return this.getOrm().deleteByPrimaryKey(this.getValueType(), primaryKeyValues);
    }

    default public int deleteByPrimaryKeyIn(String tableName, Object ... primaryKeyValues) {
        return this.getOrm().deleteByPrimaryKeyIn(tableName, primaryKeyValues);
    }

    default public int[] insert(List<T> objects) {
        return this.getOrm().insertInto(this.getTableName(), objects);
    }

    default public int insert(T object) {
        return this.getOrm().insertInto(this.getTableName(), object);
    }

    default public int[] insert(T ... objects) {
        return this.getOrm().insertInto(this.getTableName(), objects);
    }

    default public int[] insertMapIn(RowMap ... objects) {
        return this.getOrm().insertMapInto(this.getTableName(), objects);
    }

    default public int[] insertMapIn(List<RowMap> objects) {
        return this.getOrm().insertMapInto(this.getTableName(), objects);
    }

    default public InsertResult insertAndGet(List<T> objects) {
        return this.getOrm().insertAndGetIn(this.getTableName(), objects);
    }

    default public InsertResult insertAndGet(T object) {
        return this.getOrm().insertAndGetIn(this.getTableName(), object);
    }

    default public InsertResult insertAndGet(T ... objects) {
        return this.getOrm().insertAndGetIn(this.getTableName(), objects);
    }

    default public int[] merge(List<T> objects) {
        return this.getOrm().mergeIn(this.getTableName(), objects);
    }

    default public int merge(T object) {
        return this.getOrm().mergeIn(this.getTableName(), object);
    }

    default public int[] merge(T ... objects) {
        return this.getOrm().mergeIn(this.getTableName(), objects);
    }

    default public int[] update(List<T> objects) {
        return this.getOrm().updateWith(this.getTableName(), objects);
    }

    default public int update(T object) {
        return this.getOrm().updateWith(this.getTableName(), object);
    }

    default public int[] update(T ... objects) {
        return this.getOrm().updateWith(this.getTableName(), objects);
    }

    default public int updateByPrimaryKey(RowMap object, Object ... primaryKeyValues) {
        return this.getOrm().updateByPrimaryKeyIn(this.getTableName(), object, primaryKeyValues);
    }

    default public <S> List<Tuple.Tuple2<T, S>> joinUsing(TableOrm<S> other, String ... columns) {
        return this.getOrm().joinUsing(this.getValueType(), other.getValueType(), columns);
    }

    default public <S> List<Tuple.Tuple2<T, S>> joinOn(TableOrm<S> other, String onCondition) {
        return this.getOrm().joinOn(this.getValueType(), other.getValueType(), onCondition);
    }

    default public <S> List<Tuple.Tuple2<T, S>> leftJoinOn(TableOrm<S> other, String onCondition) {
        return this.getOrm().leftJoinOn(this.getValueType(), other.getValueType(), onCondition);
    }

    default public List<T> selectAll() {
        return this.getOrm().selectAll(this.getValueType());
    }

    default public T selectByPrimaryKey(Object ... primaryKeyValues) {
        return this.getOrm().selectByPrimaryKey(this.getValueType(), primaryKeyValues);
    }

    default public List<T> selectListAllEqual(Object ... tupplesOfNameAndValue) {
        return this.getOrm().readList(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public T selectFirstAllEqual(Object ... tupplesOfNameAndValue) {
        return this.getOrm().readFirst(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public T selectOneAllEqual(Object ... tupplesOfNameAndValue) {
        return this.getOrm().readOne(this.getValueType(), this.getAllEqualSql(tupplesOfNameAndValue));
    }

    default public ParameterizedSql getAllEqualSql(Object ... tupplesOfNameAndValue) {
        int argLength = tupplesOfNameAndValue.length;
        if (argLength == 0) {
            return ParameterizedSql.of(SelectSql.selectStarFrom(this.getTableName()));
        }
        int pairLength = argLength / 2;
        CharSequence[] conditions = new String[pairLength];
        Object[] parameters = new Object[pairLength];
        for (int i = 0; i < pairLength; ++i) {
            conditions[i] = String.valueOf(tupplesOfNameAndValue[i * 2]) + "=?";
            parameters[i] = tupplesOfNameAndValue[i * 2 + 1];
        }
        return ParameterizedSql.withOrderedParameters(SelectSql.selectStarFrom(this.getTableName()) + SqlKeyword.WHERE + String.join((CharSequence)SqlKeyword.AND, conditions), parameters);
    }

    default public int count() {
        return this.getOrm().readOne(Integer.TYPE, "select count(*) from " + this.getTableName(), new Object[0]);
    }

    default public ResultSetStream<T> streamAll() {
        return this.getOrm().streamAll(this.getValueType());
    }

    default public ResultSetStream<T> stream(ParameterizedSql sql) {
        return this.stream(sql.getSql(), sql.getParameters());
    }

    default public ResultSetStream<T> stream(String sql, Object ... parameters) {
        return this.getOrm().stream(this.getValueType(), sql, parameters);
    }

    default public <S> List<Tuple.Tuple2<T, S>> join(TableOrm<S> second, String sql, Object ... parameters) {
        return this.getOrm().readTupleList(this.getValueType(), second.getValueType(), sql, parameters);
    }

    default public <S, U> List<Tuple.Tuple3<T, S, U>> join(TableOrm<S> second, TableOrm<U> third, String sql, Object ... parameters) {
        return this.getOrm().readTupleList(this.getValueType(), second.getValueType(), third.getValueType(), sql, parameters);
    }
}

