/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.common.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.internal.sql.result.BasicRowMap;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public interface RowMap
extends Map<String, Object> {
    public static final ConcurrentMap<Class<?>, RecordComponent[]> recordComponentsCache = new ConcurrentHashMap();
    public static final ConcurrentMap<Class<?>, Constructor<?>> constructorCache = new ConcurrentHashMap();

    public static RowMap create() {
        return new BasicRowMap();
    }

    public static RowMap create(int initialCapacity, float loadFactor) {
        return new BasicRowMap(initialCapacity, loadFactor);
    }

    public static RowMap create(Map<String, ? extends Object> map) {
        return new BasicRowMap(map);
    }

    @SafeVarargs
    public static RowMap ofEntries(Map.Entry<String, ? extends Object> ... entries) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(entries.length * 4 / 3 + 1);
        for (Map.Entry<String, ? extends Object> e : entries) {
            m.put(e.getKey(), e.getValue());
        }
        return RowMap.create(m);
    }

    @SafeVarargs
    public static RowMap of(Object ... kvs) {
        if ((kvs.length & 1) != 0) {
            throw new IllegalArgumentException("Key/value arguments must be even.");
        }
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(kvs.length / 2 * 4 / 3 + 1);
        for (int i = 0; i < kvs.length; i += 2) {
            String k = (String)kvs[i];
            Object v = kvs[i + 1];
            m.put(k, v);
        }
        return RowMap.create(m);
    }

    public static RowMap of() {
        return RowMap.create();
    }

    public static RowMap of(String k1, Object v1) {
        return RowMap.of(new Object[]{k1, v1});
    }

    public static RowMap of(String k1, Object v1, String k2, Object v2) {
        return RowMap.of(new Object[]{k1, v1, k2, v2});
    }

    public static RowMap of(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return RowMap.of(new Object[]{k1, v1, k2, v2, k3, v3});
    }

    public static RowMap of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return RowMap.of(new Object[]{k1, v1, k2, v2, k3, v3, k4, v4});
    }

    public static String toKey(String str) {
        return SormContext.getDefaultCanonicalStringCache().toCanonicalName(str);
    }

    @Override
    public Object get(Object var1);

    public <T> T[] getArray(String var1, Class<T> var2);

    public Double getDouble(String var1);

    public Float getFloat(String var1);

    public Integer getInteger(String var1);

    public LocalDate getLocalDate(String var1);

    public LocalDateTime getLocalDateTime(String var1);

    public LocalTime getLocalTime(String var1);

    public Long getLong(String var1);

    public Object getObject(String var1);

    public String getString(String var1);

    public List<Object> getObjectList(String ... var1);

    public List<String> getStringList(String ... var1);

    public static <T extends Record> RowMap fromRecord(T src) {
        try {
            RecordComponent[] recordComponents = recordComponentsCache.computeIfAbsent(src.getClass(), key -> src.getClass().getRecordComponents());
            RowMap destMap = RowMap.create((int)((float)recordComponents.length / 0.75f), 0.75f);
            for (int i = 0; i < recordComponents.length; ++i) {
                destMap.put(recordComponents[i].getName(), recordComponents[i].getAccessor().invoke(src, new Object[0]));
            }
            return destMap;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw Try.rethrow(e);
        }
    }

    public static <T extends Record> T toRecord(RowMap src, Class<T> toType) {
        try {
            RecordComponent[] recordComponents = recordComponentsCache.computeIfAbsent(toType, key -> toType.getRecordComponents());
            Object[] args = new Object[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                args[i] = src.get(recordComponents[i].getName());
            }
            return (T)((Record)RowMap.getConstructor(recordComponents, toType).newInstance(args));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw Try.rethrow(e);
        }
    }

    public static <T> Constructor<T> getConstructor(RecordComponent[] recordComponents, Class<T> toType) {
        return constructorCache.computeIfAbsent(toType, key -> {
            Class[] types = new Class[recordComponents.length];
            for (int i = 0; i < recordComponents.length; ++i) {
                types[i] = recordComponents[i].getType();
            }
            try {
                return toType.getDeclaredConstructor(types);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw Try.rethrow(e);
            }
        });
    }

    default public <T extends Record> T toRecord(Class<T> toType) {
        return RowMap.toRecord(this, toType);
    }
}

