/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.orm.table;

import java.io.File;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.extension.h2.functions.system.CsvWrite;
import org.nkjmlab.sorm4j.internal.extension.h2.orm.table.H2SimpleTable;
import org.nkjmlab.sorm4j.table.orm.Table;

public interface H2Table<T>
extends Table<T> {
    default public void writeCsv(File toFile) {
        this.writeCsv(CsvWrite.builder(toFile).query("select * from " + this.getTableName()).build());
    }

    default public void writeCsv(CsvWrite csvWrite) {
        this.getOrm().executeUpdate("call " + csvWrite.getSql(), new Object[0]);
    }

    public static <T> H2Table<T> of(Sorm orm, Class<T> valueType) {
        return new H2SimpleTable<T>(orm, valueType);
    }

    public static <T> H2Table<T> of(Sorm orm, Class<T> valueType, String tableName) {
        return new H2SimpleTable<T>(orm, valueType, tableName);
    }
}

