/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.tools.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.h2.tools.Csv;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.common.container.RowMap;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.extension.h2.orm.H2SormFactory;
import org.nkjmlab.sorm4j.extension.h2.tools.csv.H2Csv;
import org.nkjmlab.sorm4j.mapping.ResultSetTraverser;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public class H2CsvReader
implements H2Csv {
    private final Csv csv;
    private boolean used = false;

    H2CsvReader(Csv csv) {
        this.csv = csv;
    }

    public List<RowMap> readCsvWithHeader(File inputFileName) {
        return this.readCsvWithHeader(inputFileName, StandardCharsets.UTF_8);
    }

    public List<RowMap> readCsvWithHeader(File inputFileName, Charset charset) {
        List<RowMap> list;
        block8: {
            Reader in = H2CsvReader.newBufferedReader(inputFileName, charset);
            try {
                list = this.readCsvWithHeader(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Try.rethrow(e);
                }
            }
            in.close();
        }
        return list;
    }

    private static Reader newBufferedReader(File inputFileName, Charset charset) throws IOException {
        return Files.newBufferedReader(inputFileName.toPath(), charset != null ? charset : StandardCharsets.UTF_8);
    }

    public List<RowMap> readCsvWithHeader(Reader in) {
        List<RowMap> list;
        block8: {
            ResultSet rs = this.readCsv(in, null);
            try {
                list = this.traverseAndMap(rs);
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            rs.close();
        }
        return list;
    }

    private ResultSet readCsv(Reader in, String[] colNames) throws IOException {
        if (this.used) {
            throw new SormException("This H2Csv instance has already been used and cannot be reused.");
        }
        this.used = true;
        return this.csv.read(in, colNames);
    }

    public List<RowMap> readCsvWithoutHeader(File inputFileName, Charset charset, String[] colNames) {
        List<RowMap> list;
        block8: {
            Reader in = H2CsvReader.newBufferedReader(inputFileName, charset);
            try {
                list = this.readCsvWithoutHeader(in, colNames);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Try.rethrow(e);
                }
            }
            in.close();
        }
        return list;
    }

    public List<RowMap> readCsvWithoutHeader(File inputFileName, String[] colNames) {
        return this.readCsvWithoutHeader(inputFileName, StandardCharsets.UTF_8, colNames);
    }

    public List<RowMap> readCsvWithoutHeader(Reader in, String[] colNames) {
        List<RowMap> list;
        block8: {
            ResultSet rs = this.readCsv(in, colNames);
            try {
                list = this.traverseAndMap(rs);
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            rs.close();
        }
        return list;
    }

    public List<RowMap> readCsvReplacedHeader(File inputFileName, Charset charset, String[] colNames) {
        List<RowMap> list;
        block8: {
            Reader in = H2CsvReader.newBufferedReader(inputFileName, charset);
            try {
                list = this.readCsvReplacedHeader(in, colNames);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Try.rethrow(e);
                }
            }
            in.close();
        }
        return list;
    }

    public List<RowMap> readCsvReplacedHeader(Reader in, String[] colNames) {
        List<RowMap> list;
        block8: {
            ResultSet rs = this.csv.read(H2CsvReader.toHeaderSkippingReader(in), colNames);
            try {
                list = this.traverseAndMap(rs);
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            rs.close();
        }
        return list;
    }

    public List<RowMap> readCsvReplacedHeader(File inputFileName, String[] colNames) {
        return this.readCsvReplacedHeader(inputFileName, StandardCharsets.UTF_8, colNames);
    }

    private List<RowMap> traverseAndMap(ResultSet rs) throws SQLException {
        Sorm sorm = H2SormFactory.createTemporalInMemory();
        ResultSetTraverser<List<RowMap>> t = sorm.getResultSetTraverser(RowMap.class);
        return t.traverseAndMap(rs);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static Reader toHeaderSkippingReader(Reader input) throws IOException {
        int bs = 8192;
        BufferedReader reader = new BufferedReader(input, 8192);
        reader.readLine();
        reader.mark(8192);
        return reader;
    }

    public static class Builder
    extends H2Csv.Builder<H2CsvReader, Builder> {
        @Override
        public H2CsvReader build() {
            return new H2CsvReader(this.csv);
        }
    }
}

