/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.tools.csv;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.h2.tools.Csv;
import org.nkjmlab.sorm4j.extension.h2.tools.csv.H2Csv;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public class H2CsvWriter {
    private final Csv csv;

    private H2CsvWriter(Csv csv) {
        this.csv = csv;
    }

    public int writeCsv(DataSource dataSource, File outputFileName, String sql, Charset charset) {
        int n;
        block8: {
            Connection conn = dataSource.getConnection();
            try {
                n = this.writeCsv(conn, outputFileName, sql, charset);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw Try.rethrow(e);
                }
            }
            conn.close();
        }
        return n;
    }

    public int writeCsv(Connection conn, File outputFileName, String sql, Charset charset) {
        try {
            return this.csv.write(conn, outputFileName.toString(), sql, charset.name());
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    public int writeCsv(DataSource dataSource, File outputFileName, String sql) {
        return this.writeCsv(dataSource, outputFileName, sql, StandardCharsets.UTF_8);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends H2Csv.Builder<H2CsvWriter, Builder> {
        @Override
        public H2CsvWriter build() {
            return new H2CsvWriter(this.csv);
        }
    }
}

