/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.tools.server.tcp;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.server.TcpServer;
import org.h2.tools.Server;
import org.nkjmlab.sorm4j.extension.h2.tools.server.H2Server;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public class H2TcpServer
implements H2Server {
    private final H2TcpServerProperties properties;
    private final Server server;

    private H2TcpServer(H2TcpServerProperties properties) {
        this.properties = properties;
        try {
            this.server = Server.createTcpServer((String[])properties.toArgs());
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public void stop() throws SQLException {
        if (!this.isRunning()) {
            return;
        }
        Server.shutdownTcpServer((String)this.getUrl(), (String)this.properties.tcpPassword(), (boolean)false, (boolean)false);
    }

    public TcpServer getTcpServer() {
        return (TcpServer)this.getService();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    public static Builder builder(String tcpPassword) {
        return new Builder(tcpPassword);
    }

    public record H2TcpServerProperties(Integer tcpPort, String tcpPassword, boolean tcpSSL, boolean tcpAllowOthers, boolean tcpDaemon, boolean trace, boolean ifExists, boolean ifNotExists, String baseDir, String keyFrom, String keyTo) {
        public String[] toArgs() {
            ArrayList<String> args = new ArrayList<String>();
            if (this.tcpPort != null) {
                args.add("-tcpPort");
                args.add(String.valueOf(this.tcpPort));
            }
            if (this.tcpPassword != null) {
                args.add("-tcpPassword");
                args.add(this.tcpPassword);
            }
            if (this.tcpSSL) {
                args.add("-tcpSSL");
            }
            if (this.tcpAllowOthers) {
                args.add("-tcpAllowOthers");
            }
            if (this.tcpDaemon) {
                args.add("-tcpDaemon");
            }
            if (this.trace) {
                args.add("-trace");
            }
            if (this.ifExists) {
                args.add("-ifExists");
            }
            if (this.ifNotExists) {
                args.add("-ifNotExists");
            }
            if (this.baseDir != null) {
                args.add("-baseDir");
                args.add(this.baseDir);
            }
            if (this.keyFrom != null) {
                args.add("-key");
                args.add(this.keyFrom);
                args.add(this.keyTo);
            }
            return (String[])args.toArray(String[]::new);
        }
    }

    public static class Builder {
        private Integer tcpPort;
        private String tcpPassword;
        private boolean tcpSSL;
        private boolean tcpAllowOthers;
        private boolean tcpDaemon;
        private boolean trace;
        private boolean ifExists = true;
        private boolean ifNotExists = false;
        private String baseDir;
        private String keyFrom;
        private String keyTo;

        public Builder(String tcpPassword) {
            this.tcpPassword(tcpPassword);
        }

        public Builder tcpPort(Integer port) {
            this.tcpPort = port;
            return this;
        }

        public Builder tcpPassword(String password) {
            this.tcpPassword = password;
            return this;
        }

        public Builder tcpSSL(boolean tcpSSL) {
            this.tcpSSL = tcpSSL;
            return this;
        }

        public Builder tcpAllowOthers(boolean tcpAllowOthers) {
            this.tcpAllowOthers = tcpAllowOthers;
            return this;
        }

        public Builder tcpDaemon(boolean tcpDaemon) {
            this.tcpDaemon = tcpDaemon;
            return this;
        }

        public Builder trace(boolean trace) {
            this.trace = trace;
            return this;
        }

        public Builder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        public Builder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        public Builder baseDir(String baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        public Builder key(String keyFrom, String keyTo) {
            this.keyFrom = keyFrom;
            this.keyTo = keyTo;
            return this;
        }

        public H2TcpServer build() {
            return new H2TcpServer(new H2TcpServerProperties(this.tcpPort, this.tcpPassword, this.tcpSSL, this.tcpAllowOthers, this.tcpDaemon, this.trace, this.ifExists, this.ifNotExists, this.baseDir, this.keyFrom, this.keyTo));
        }
    }
}

