/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.extension.h2.tools.server.web;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.server.web.WebServer;
import org.h2.tools.Server;
import org.nkjmlab.sorm4j.extension.h2.tools.server.H2Server;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public class H2WebServer
implements H2Server {
    private final Server server;

    public H2WebServer(H2WebServerProperties properties) {
        try {
            this.server = Server.createWebServer((String[])properties.toArgs());
            this.server.setShutdownHandler(() -> this.server.stop());
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.server.stop();
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    public WebServer getWebServer() {
        return (WebServer)this.getService();
    }

    public String createSession(Connection conn) {
        try {
            return this.getWebServer().addSession(conn);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    public String openBrowser(Connection connection) {
        try {
            String url = this.createSession(connection);
            Server.openBrowser((String)url);
            return url;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public record H2WebServerProperties(Integer webPort, boolean webSSL, boolean webAllowOthers, boolean webDaemon, boolean trace, boolean ifExists, boolean ifNotExists, String baseDir) {
        public String[] toArgs() {
            ArrayList<String> args = new ArrayList<String>();
            if (this.webPort != null) {
                args.add("-webPort");
                args.add(String.valueOf(this.webPort));
            }
            if (this.webSSL) {
                args.add("-webSSL");
            }
            if (this.webAllowOthers) {
                args.add("-webAllowOthers");
            }
            if (this.webDaemon) {
                args.add("-webDaemon");
            }
            if (this.trace) {
                args.add("-trace");
            }
            if (this.ifExists) {
                args.add("-ifExists");
            }
            if (this.ifNotExists) {
                args.add("-ifNotExists");
            }
            if (this.baseDir != null) {
                args.add("-baseDir");
                args.add(this.baseDir);
            }
            return (String[])args.toArray(String[]::new);
        }
    }

    public static class Builder {
        private Integer webPort;
        private boolean webSSL;
        private boolean webAllowOthers;
        private boolean webDaemon;
        private boolean trace;
        private boolean ifExists = true;
        private boolean ifNotExists = false;
        private String baseDir;

        public Builder webPort(int port) {
            this.webPort = port;
            return this;
        }

        public Builder webSSL(boolean webSSL) {
            this.webSSL = webSSL;
            return this;
        }

        public Builder webAllowOthers(boolean webAllowOthers) {
            this.webAllowOthers = webAllowOthers;
            return this;
        }

        public Builder webDaemon(boolean webDaemon) {
            this.webDaemon = webDaemon;
            return this;
        }

        public Builder trace(boolean trace) {
            this.trace = trace;
            return this;
        }

        public Builder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        public Builder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        public Builder baseDir(String baseDir) {
            this.baseDir = baseDir;
            return this;
        }

        public H2WebServer build() {
            return new H2WebServer(new H2WebServerProperties(this.webPort, this.webSSL, this.webAllowOthers, this.webDaemon, this.trace, this.ifExists, this.ifNotExists, this.baseDir));
        }
    }
}

