/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.context.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.nkjmlab.sorm4j.internal.context.TableMetaDataParser;
import org.nkjmlab.sorm4j.internal.context.common.ColumnMetaDataImpl;
import org.nkjmlab.sorm4j.internal.sql.metadata.ColumnMetaData;

public final class DefaultTableMetaDataParser
implements TableMetaDataParser {
    @Override
    public List<String> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");){
            ArrayList<String> columnsList = new ArrayList<String>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                String isAutoIncrement = resultSet.getString(23);
                String isGenerated = resultSet.getString(24);
                if (!isAutoIncrement.equals("YES") && !isGenerated.equals("YES")) continue;
                columnsList.add(columnName);
            }
            ArrayList<String> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<ColumnMetaData> getColumnsMetaData(DatabaseMetaData metaData, String _tableName) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), _tableName, "%");){
            ArrayList<ColumnMetaData> columnsList = new ArrayList<ColumnMetaData>();
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                String typeName = resultSet.getString(6);
                columnsList.add(new ColumnMetaDataImpl(columnName, typeName));
            }
            ArrayList<ColumnMetaData> arrayList = columnsList;
            return arrayList;
        }
    }

    @Override
    public List<String> getPrimaryKeys(DatabaseMetaData metaData, String tableName) throws SQLException {
        ArrayList<String> primaryKeysList = new ArrayList<String>();
        try (ResultSet resultSet = metaData.getPrimaryKeys(null, this.getSchemaPattern(metaData), tableName);){
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                primaryKeysList.add(columnName);
            }
            ArrayList<String> arrayList = primaryKeysList;
            return arrayList;
        }
    }

    private String getSchemaPattern(DatabaseMetaData metaData) throws SQLException {
        return "Oracle".equalsIgnoreCase(metaData.getDatabaseProductName()) ? "%" : null;
    }
}

