/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.multirow;

import org.nkjmlab.sorm4j.context.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.context.logging.LogContext;
import org.nkjmlab.sorm4j.internal.context.PreparedStatementSupplier;
import org.nkjmlab.sorm4j.internal.context.SqlParametersSetter;
import org.nkjmlab.sorm4j.internal.mapping.ContainerToTableMapper;
import org.nkjmlab.sorm4j.internal.mapping.multirow.BatchOfMultiRowInOneStatementProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowInOneStatementProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.MultiRowProcessor;
import org.nkjmlab.sorm4j.internal.mapping.multirow.SimpleBatchProcessor;

public class MultiRowProcessorFactoryImpl
implements MultiRowProcessorFactory {
    private final MultiRowProcessorFactory.ProcessorType multiRowProcessorType;
    private final int batchSize;
    private final int batchSizeWithMultiRow;
    private final int multiRowSize;

    public MultiRowProcessorFactoryImpl(MultiRowProcessorFactory.ProcessorType multiRowProcessorType, int batchSize, int multiRowSize, int batchSizeWithMultiRow) {
        this.multiRowProcessorType = multiRowProcessorType;
        this.batchSize = batchSize;
        this.multiRowSize = multiRowSize;
        this.batchSizeWithMultiRow = batchSizeWithMultiRow;
    }

    @Override
    public <T> MultiRowProcessor<T> createMultiRowProcessor(LogContext loggerContext, SqlParametersSetter sqlParametersSetter, PreparedStatementSupplier statementSupplier, Class<T> objectClass, ContainerToTableMapper<T> tableMapping) {
        switch (this.multiRowProcessorType) {
            case SIMPLE_BATCH: {
                return new SimpleBatchProcessor<T>(loggerContext, sqlParametersSetter, statementSupplier, tableMapping, this.batchSize);
            }
            case MULTI_ROW: {
                return new MultiRowInOneStatementProcessor<T>(loggerContext, sqlParametersSetter, statementSupplier, tableMapping, this.batchSize, this.multiRowSize);
            }
            case MULTI_ROW_AND_BATCH: {
                return new BatchOfMultiRowInOneStatementProcessor<T>(loggerContext, sqlParametersSetter, statementSupplier, tableMapping, this.batchSize, this.multiRowSize, this.batchSizeWithMultiRow);
            }
        }
        throw new IllegalStateException(String.valueOf((Object)this.multiRowProcessorType) + " is invalid");
    }

    public String toString() {
        return "MultiRowProcessorFactory [multiRowProcessorType=" + String.valueOf((Object)this.multiRowProcessorType) + ", batchSize=" + this.batchSize + ", batchSizeWithMultiRow=" + this.batchSizeWithMultiRow + ", multiRowSize=" + this.multiRowSize + "]";
    }
}

