/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.result;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.context.SormContext;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.result.ResultsContainerFactory;
import org.nkjmlab.sorm4j.internal.util.JdbcTypeUtils;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;

final class ResultsContainerWithConstructorFactory<T>
implements ResultsContainerFactory<T> {
    private final Map<String, ConstructorParameter> constructorParametersMap = new HashMap<String, ConstructorParameter>();
    private final int constructorParametersLength;
    private final Map<List<String>, ConstructorParameter[]> columnAndConstructorParameterMapping = new ConcurrentHashMap<List<String>, ConstructorParameter[]>();
    private final Constructor<T> constructor;

    public ResultsContainerWithConstructorFactory(ColumnToAccessorMapping columnToAccessorMap, Constructor<T> constructor, String[] parameterNames) {
        this.constructor = constructor;
        String columnAliasPrefix = columnToAccessorMap.getColumnAliasPrefix();
        Parameter[] parameters = constructor.getParameters();
        this.constructorParametersLength = parameters.length;
        for (int i = 0; i < this.constructorParametersLength; ++i) {
            Parameter parameter = parameters[i];
            String canonicalName = SormContext.getDefaultCanonicalStringCache().toCanonicalName(parameterNames[i]);
            ConstructorParameter cp = new ConstructorParameter(canonicalName, i, parameter.getType());
            this.constructorParametersMap.put(canonicalName, cp);
            if (columnAliasPrefix == null || columnAliasPrefix.length() == 0) continue;
            this.constructorParametersMap.put(SormContext.getDefaultCanonicalStringCache().toCanonicalNameWithTableName(columnAliasPrefix, parameterNames[i]), cp);
        }
    }

    private T createContainerObject(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, int[] sqlTypes, ConstructorParameter[] constructorParameters) {
        try {
            Object[] params = new Object[this.constructorParametersLength];
            for (int i = 0; i < constructorParameters.length; ++i) {
                ConstructorParameter cp = constructorParameters[i];
                if (cp == null) continue;
                params[cp.getOrder()] = columnValueConverter.convertTo(resultSet, i + 1, sqlTypes[i], constructorParameters[i].getType());
            }
            return this.constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            Object[] params = new Object[]{this.constructor.getDeclaringClass(), JdbcTypeUtils.convert(sqlTypes), constructorParameters};
            throw new SormException(ParameterizedStringFormatter.NO_LENGTH_LIMIT.format("Constructor with parameters of container class [{}] for object-relation mapping is not match with columns. param={}, sqltypes={}", params), e);
        }
    }

    private ConstructorParameter[] getCorrespondingParameter(String[] columns) {
        return this.columnAndConstructorParameterMapping.computeIfAbsent(Arrays.asList(columns), key -> (ConstructorParameter[])Arrays.stream(columns).map(col -> this.constructorParametersMap.get(SormContext.getDefaultCanonicalStringCache().toCanonicalName((String)col))).toArray(ConstructorParameter[]::new));
    }

    @Override
    public List<T> createContainerList(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, OrmConnectionImpl.ColumnsAndTypes columnsAndTypes) throws SQLException {
        String[] columns = columnsAndTypes.getColumns();
        int[] sqlTypes = columnsAndTypes.getColumnTypes();
        ConstructorParameter[] constructorParameters = this.getCorrespondingParameter(columns);
        ArrayList<T> ret = new ArrayList<T>();
        while (resultSet.next()) {
            ret.add(this.createContainerObject(columnValueConverter, resultSet, sqlTypes, constructorParameters));
        }
        return ret;
    }

    @Override
    public T createContainer(ColumnValueToJavaObjectConverters columnValueConverter, ResultSet resultSet, OrmConnectionImpl.ColumnsAndTypes columnsAndTypes) throws SQLException {
        String[] columns = columnsAndTypes.getColumns();
        int[] sqlTypes = columnsAndTypes.getColumnTypes();
        ConstructorParameter[] constructorParameters = this.getCorrespondingParameter(columns);
        return this.createContainerObject(columnValueConverter, resultSet, sqlTypes, constructorParameters);
    }

    public String toString() {
        List keySet = this.constructorParametersMap.keySet().stream().sorted().collect(Collectors.toList());
        Object[] params = new Object[]{this.constructor, keySet, String.join((CharSequence)System.lineSeparator(), keySet.stream().map(key -> "  " + key + "=>" + String.valueOf(this.constructorParametersMap.get(key))).collect(Collectors.toList()))};
        return ParameterizedStringFormatter.LENGTH_256.format("constructor=[{}], arguments={}" + System.lineSeparator() + "{}", params);
    }

    static final class ConstructorParameter {
        private final String name;
        private final int order;
        private final Class<?> type;

        public ConstructorParameter(String name, int order, Class<?> type) {
            this.name = name;
            this.order = order;
            this.type = type;
        }

        public int getOrder() {
            return this.order;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String toString() {
            return "[name=" + this.name + ", order=" + this.order + ", type=" + String.valueOf(this.type) + "]";
        }
    }
}

