/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.mapping.result;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.common.exception.SormException;
import org.nkjmlab.sorm4j.internal.OrmConnectionImpl;
import org.nkjmlab.sorm4j.internal.context.ColumnValueToJavaObjectConverters;
import org.nkjmlab.sorm4j.internal.mapping.ColumnToAccessorMapping;
import org.nkjmlab.sorm4j.internal.mapping.result.ResultsContainerFactory;
import org.nkjmlab.sorm4j.internal.mapping.result.ResultsContainerWithConstructorFactory;
import org.nkjmlab.sorm4j.internal.mapping.result.ResultsContainerWithSetterFactory;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.internal.util.reflection.ReflectionConstrucorsUtils;
import org.nkjmlab.sorm4j.mapping.annotation.OrmConstructor;
import org.nkjmlab.sorm4j.mapping.annotation.OrmRecordCompatibleConstructor;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public final class ResultsToContainerMapper<T> {
    private final Class<T> objectClass;
    private final Map<Class<?>, OrmConnectionImpl.ColumnsAndTypes> metaDataForSelectByPrimaryKey = new ConcurrentHashMap();
    private final ColumnValueToJavaObjectConverters columnValueConverter;
    private final ColumnToAccessorMapping columnToAccessorMap;
    private final ResultsContainerFactory<T> resultsContainerFactory;

    public ResultsToContainerMapper(ColumnValueToJavaObjectConverters converter, Class<T> objectClass, ColumnToAccessorMapping columnToAccessorMap) {
        this.columnValueConverter = converter;
        this.objectClass = objectClass;
        this.columnToAccessorMap = columnToAccessorMap;
        this.resultsContainerFactory = this.createResultsContainerFactory();
    }

    private ResultsContainerFactory<T> createResultsContainerFactory() {
        ReflectionConstrucorsUtils.OrmConstructorDefinition<T> constructorDef = ReflectionConstrucorsUtils.createOrmConstructorDefinition(this.objectClass);
        if (constructorDef != null) {
            return new ResultsContainerWithConstructorFactory<T>(this.getColumnToAccessorMap(), constructorDef.constructor(), constructorDef.parameterNames());
        }
        Constructor<T> defaultConstructor = ReflectionConstrucorsUtils.getDefaultConstructor(this.objectClass);
        if (defaultConstructor != null) {
            return new ResultsContainerWithSetterFactory<T>(this.getColumnToAccessorMap(), defaultConstructor);
        }
        Object[] params = new Object[]{this.objectClass, OrmConstructor.class.getSimpleName(), OrmRecordCompatibleConstructor.class.getSimpleName()};
        throw new SormException(ParameterizedStringFormatter.LENGTH_256.format("The given container class [{}] should be record class, must be a record class, have a constructor annotated with @{}, have a constructor annotated with @{}, or have a default constructor.", params));
    }

    public List<T> traverseAndMap(ResultSet resultSet) throws SQLException {
        OrmConnectionImpl.ColumnsAndTypes columnsAndTypes = OrmConnectionImpl.ColumnsAndTypes.createColumnsAndTypes(resultSet);
        return this.resultsContainerFactory.createContainerList(this.columnValueConverter, resultSet, columnsAndTypes);
    }

    public T mapResultsToContainer(ResultSet resultSet) throws SQLException {
        OrmConnectionImpl.ColumnsAndTypes columnsAndTypes = OrmConnectionImpl.ColumnsAndTypes.createColumnsAndTypes(resultSet);
        return this.resultsContainerFactory.createContainer(this.columnValueConverter, resultSet, columnsAndTypes);
    }

    public T mapResultsToContainerByPrimaryKey(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        OrmConnectionImpl.ColumnsAndTypes columnsAndTypes = this.metaDataForSelectByPrimaryKey.computeIfAbsent(objectClass, key -> ResultsToContainerMapper.createColumnsAndTypes(resultSet));
        return this.resultsContainerFactory.createContainer(this.columnValueConverter, resultSet, columnsAndTypes);
    }

    private static OrmConnectionImpl.ColumnsAndTypes createColumnsAndTypes(ResultSet resultSet) {
        try {
            return OrmConnectionImpl.ColumnsAndTypes.createColumnsAndTypes(resultSet);
        }
        catch (SQLException e) {
            throw Try.rethrow(e);
        }
    }

    private ColumnToAccessorMapping getColumnToAccessorMap() {
        return this.columnToAccessorMap;
    }

    public String toString() {
        Object[] params = new Object[]{this.objectClass.getName(), this.resultsContainerFactory.getClass().getSimpleName(), this.resultsContainerFactory.toString()};
        return ParameterizedStringFormatter.LENGTH_256.format("[{}] instance used as SQL result container will be created by [{}]" + System.lineSeparator() + "{}", params);
    }
}

