/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.sql.metadata.jdbc;

import org.nkjmlab.sorm4j.internal.util.ParameterizedStringFormatter;
import org.nkjmlab.sorm4j.sql.metadata.jdbc.JdbcColumnMetaData;

public class JdbcColumnMetaDataImpl
implements JdbcColumnMetaData {
    private final String columnName;
    private final String typeName;
    private final String tableCatalog;
    private final String tableSchema;
    private final String tableName;
    private final int dataType;
    private final int columnSize;
    private final int numPrecRadix;
    private final int decimalDigits;
    private final int ordinalPosition;
    private final int nullableFlag;
    private final int charOctetLength;
    private final String isNullable;
    private final String columnDefault;
    private final String remarks;
    private final String isAutoIncremented;
    private final String isGenerated;
    private final String msg;

    public JdbcColumnMetaDataImpl(String tableCatalog, String tableSchema, String tableName, String columnName, int dataType, String typeName, int columnSize, int numPrecRadix, int decimalDigits, int ordinalPosition, int nullableFlag, int charOctetLength, String isNullable, String columnDefault, String remarks, String isAutoIncremented, String isGenerated) {
        this.columnName = columnName;
        this.typeName = typeName;
        this.tableCatalog = tableCatalog;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
        this.dataType = dataType;
        this.columnSize = columnSize;
        this.decimalDigits = decimalDigits;
        this.numPrecRadix = numPrecRadix;
        this.ordinalPosition = ordinalPosition;
        this.nullableFlag = nullableFlag;
        this.charOctetLength = charOctetLength;
        this.isNullable = isNullable;
        this.columnDefault = columnDefault;
        this.remarks = remarks;
        this.isAutoIncremented = isAutoIncremented;
        this.isGenerated = isGenerated;
        Object[] params = new Object[]{tableCatalog, tableSchema, tableName, String.format("%02d", ordinalPosition), columnName, typeName, dataType, columnSize, decimalDigits, numPrecRadix, charOctetLength, nullableFlag, isNullable, columnDefault, remarks, isAutoIncremented, isGenerated};
        this.msg = ParameterizedStringFormatter.LENGTH_256.format("{{}.{}.{}: {} {} [{}({})] [size={}, decimal={}, radix={}, octetLen={}, nullableFlag={}] [n={}, default='{}', comment='{}'] [a={}, g={}]}", params);
    }

    @Override
    public String getTableCatalog() {
        return this.tableCatalog;
    }

    @Override
    public String getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public int getColumnSize() {
        return this.columnSize;
    }

    @Override
    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    @Override
    public int getNumPrecRadix() {
        return this.numPrecRadix;
    }

    @Override
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @Override
    public int getNullableFlag() {
        return this.nullableFlag;
    }

    @Override
    public int getCharOctetLength() {
        return this.charOctetLength;
    }

    @Override
    public String getIsNullable() {
        return this.isNullable;
    }

    @Override
    public String getColumnDefault() {
        return this.columnDefault;
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public String getIsAutoIncremented() {
        return this.isAutoIncremented;
    }

    @Override
    public String getIsGenerated() {
        return this.isGenerated;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public String toString() {
        return this.msg;
    }
}

