/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nkjmlab.sorm4j.internal.util.CanonicalStringUtils;

public final class CanonicalStringCache {
    private final Map<String, String> cache;
    private final String tableAndColumnSeparator;
    public static final CanonicalStringCache DEFAULT = new CanonicalStringCache(new ConcurrentHashMap<String, String>(), "_DOT_");

    public static CanonicalStringCache getDefault() {
        return DEFAULT;
    }

    public CanonicalStringCache(Map<String, String> map, String tableAndColumnSeparator) {
        this.cache = map;
        this.tableAndColumnSeparator = tableAndColumnSeparator;
    }

    public String toCanonicalName(String name) {
        return this.cache.computeIfAbsent(name, key -> CanonicalStringUtils.canonicalize(name));
    }

    public String toCanonicalNameWithTableName(String tableName, String columnName) {
        return this.toCanonicalName(tableName) + this.tableAndColumnSeparator + this.toCanonicalName(columnName);
    }

    public boolean containsCanonicalName(Collection<String> collection, String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return collection.stream().anyMatch(e -> this.equalsCanonicalName((String)e, name));
    }

    public boolean equalsCanonicalName(String name, String other) {
        return this.toCanonicalName(name).equals(this.toCanonicalName(other));
    }

    public String toString() {
        return this.cache.toString();
    }

    public Map<String, String> getCache() {
        return this.cache;
    }
}

