/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.internal.util;

import java.util.Locale;
import javax.lang.model.SourceVersion;

public final class CanonicalStringUtils {
    private CanonicalStringUtils() {
    }

    public static String canonicalize(String name) {
        return CanonicalStringUtils.toUpperSnakeCase(CanonicalStringUtils.sanitizeIdentifier(name));
    }

    public static String toUpperSnakeCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (CanonicalStringUtils.containsNonAscii(s)) {
            return s.toUpperCase(Locale.ROOT);
        }
        StringBuilder out = new StringBuilder(s.length() + 8);
        char prev = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            char next;
            char c = s.charAt(i);
            char c2 = next = i + 1 < s.length() ? s.charAt(i + 1) : (char)'\u0000';
            if (i > 0 && CanonicalStringUtils.shouldInsertUnderscore(prev, c, next)) {
                out.append('_');
            }
            out.append(Character.toUpperCase(c));
            prev = c;
        }
        return out.toString();
    }

    private static boolean containsNonAscii(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    private static boolean shouldInsertUnderscore(char prev, char curr, char next) {
        boolean prevIsLower = prev >= 'a' && prev <= 'z';
        boolean prevIsDigit = prev >= '0' && prev <= '9';
        boolean prevIsUpper = prev >= 'A' && prev <= 'Z';
        boolean currIsUpper = curr >= 'A' && curr <= 'Z';
        boolean nextIsLower = next >= 'a' && next <= 'z';
        boolean camelBoundary = currIsUpper && (prevIsLower || prevIsDigit);
        boolean acronymBoundary = currIsUpper && prevIsUpper && nextIsLower;
        boolean letterDigitBoundary = Character.isDigit(curr) && Character.isLetter(prev) || Character.isLetter(curr) && Character.isDigit(prev);
        return camelBoundary || acronymBoundary || letterDigitBoundary;
    }

    public static String toLowerSnakeCase(String s) {
        return CanonicalStringUtils.toUpperSnakeCase(s).toLowerCase(Locale.ROOT);
    }

    public static String sanitizeIdentifier(String raw) {
        Object candidate;
        int cp;
        if (raw == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (raw.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        StringBuilder sb = new StringBuilder(raw.length());
        boolean prevUnderscore = false;
        int index = 0;
        for (int offset = 0; offset < raw.length(); offset += Character.charCount(cp)) {
            boolean ok;
            cp = raw.codePointAt(offset);
            boolean bl = ok = index == 0 && Character.isJavaIdentifierStart(cp) || index > 0 && Character.isJavaIdentifierPart(cp);
            if (ok) {
                if (cp == 95) {
                    if (!prevUnderscore) {
                        sb.append('_');
                        prevUnderscore = true;
                    }
                } else {
                    sb.appendCodePoint(cp);
                    prevUnderscore = false;
                }
            } else if (!prevUnderscore) {
                sb.append('_');
                prevUnderscore = true;
            }
            ++index;
        }
        int len = sb.length();
        if (len == 0) {
            throw new IllegalArgumentException("empty after sanitization");
        }
        if (sb.charAt(len - 1) == '_') {
            sb.setLength(len - 1);
            if (sb.length() == 0) {
                throw new IllegalArgumentException("empty after trimming trailing underscore");
            }
        }
        if (!Character.isJavaIdentifierStart(sb.codePointAt(0))) {
            sb.insert(0, '_');
        }
        if (!SourceVersion.isIdentifier((CharSequence)(candidate = sb.toString())) && !SourceVersion.isIdentifier((CharSequence)(candidate = "_" + (String)candidate))) {
            throw new IllegalArgumentException("not a legal Java identifier: " + (String)candidate);
        }
        return candidate;
    }

    public static String toPascalCase(String snake) {
        if (snake == null || snake.isEmpty()) {
            return snake;
        }
        String[] parts = snake.toLowerCase(Locale.ROOT).split("_");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            sb.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            sb.append(part.substring(1));
        }
        return sb.toString();
    }

    public static String toCamelCase(String snake) {
        String pascal = CanonicalStringUtils.toPascalCase(snake);
        if (snake == null || pascal.isEmpty()) {
            return pascal;
        }
        return Character.toLowerCase(pascal.charAt(0)) + pascal.substring(1);
    }
}

