/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sql.statement;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.sql.statement.ConditionSql;
import org.nkjmlab.sorm4j.sql.statement.SqlKeyword;
import org.nkjmlab.sorm4j.sql.statement.SqlStringUtils;

public class SelectSql {
    public static Builder builder() {
        return new Builder();
    }

    public static String select(String selectClause) {
        return SelectSql.wrapSpace("select " + selectClause);
    }

    public static String select(Object ... selectClauses) {
        return SelectSql.wrapSpace("select " + SqlStringUtils.join(", ", selectClauses));
    }

    public static String selectDistinct(Object ... selectClauses) {
        return SelectSql.wrapSpace("select distinct " + SqlStringUtils.join(", ", selectClauses));
    }

    public static String selectStarFrom(String tableName) {
        return SelectSql.wrapSpace("select *" + SelectSql.from(tableName));
    }

    public static String selectCountFrom(String tableName) {
        return SelectSql.wrapSpace("select count(*)" + SelectSql.from(tableName));
    }

    public static String as(Object src, String alias) {
        return String.valueOf(src) + SqlKeyword.AS + alias;
    }

    public static String castAs(String src, String toType) {
        return SelectSql.wrapSpace("cast" + SelectSql.wrapParentheses(src + SqlKeyword.AS + toType));
    }

    public static String columnWithTableName(String tableName, String ... colNames) {
        return SelectSql.wrapSpace(Arrays.stream(colNames).map(col -> SelectSql.column(tableName, col)).collect(Collectors.joining(",")));
    }

    public static String column(String tableName, String colName) {
        return SelectSql.wrapSpace(tableName + "." + colName);
    }

    public static String from(String tableName) {
        return SelectSql.wrapSpace("from " + tableName);
    }

    public static String where() {
        return SqlKeyword.WHERE;
    }

    public static String where(String searchCondition) {
        return SelectSql.wrapSpace("where " + searchCondition);
    }

    public static String where(ConditionSql searchCondition) {
        return SelectSql.where(searchCondition.toString());
    }

    public static String op(Object left, String operator, Object right) {
        return SelectSql.wrapParentheses(String.valueOf(left) + SelectSql.wrapSpace(operator) + String.valueOf(right));
    }

    public static String groupBy(Object ... groups) {
        return SelectSql.wrapSpace("group by " + SqlStringUtils.join(", ", groups));
    }

    public static String limit(Object limit) {
        return SelectSql.wrapSpace("limit " + String.valueOf(limit));
    }

    public static String orderBy(Object ... order) {
        return SelectSql.wrapSpace("order by " + SqlStringUtils.join(" ", order));
    }

    public static String orderBy(Object column) {
        return SelectSql.orderBy(column, "");
    }

    public static String orderByAsc(Object column) {
        return SelectSql.orderBy(column, "asc");
    }

    public static String orderByDesc(Object column) {
        return SelectSql.orderBy(column, "desc");
    }

    public static String func(String functionName, Object args) {
        return SelectSql.wrapSpace(functionName + SelectSql.wrapParentheses(args));
    }

    public static String func(String functionName, Object ... args) {
        return SelectSql.wrapSpace(functionName + SelectSql.wrapParentheses(SqlStringUtils.join(", ", args)));
    }

    public static String count(String column) {
        return SelectSql.func("count", (Object)column);
    }

    public static String sum(String column) {
        return SelectSql.func("sum", (Object)column);
    }

    public static String avg(String column) {
        return SelectSql.func("avg", (Object)column);
    }

    static String wrapParentheses(Object str) {
        return str == null ? null : "(" + String.valueOf(str) + ")";
    }

    static String wrapSpace(Object str) {
        return str == null ? null : " " + str.toString().trim() + " ";
    }

    public static class Builder {
        private String columns = "*";
        private boolean distinct = false;
        private String from;
        private String where;
        private String groupBy;
        private String orderBy;
        private String having;
        private String limit;

        private Builder() {
        }

        public String build() {
            return this.toString();
        }

        public Builder distinct() {
            this.distinct = true;
            return this;
        }

        public Builder from(String ... tables) {
            this.from = String.join((CharSequence)",", tables);
            return this;
        }

        public Builder groupBy(String ... columns) {
            this.groupBy = String.join((CharSequence)",", Arrays.stream(columns).collect(Collectors.toList()));
            return this;
        }

        public Builder having(ConditionSql condition) {
            this.having(condition.toString());
            return this;
        }

        public Builder having(String expr) {
            this.having = expr;
            return this;
        }

        public Builder limit(int limit) {
            return this.limit(limit, 0);
        }

        public Builder limit(int limit, int offset) {
            this.limit = limit + (String)(offset > 0 ? " offset " + offset : "");
            return this;
        }

        public Builder orderBy(String ... order) {
            this.orderBy = String.join((CharSequence)" ", order);
            return this;
        }

        public Builder select(String ... columns) {
            this.columns = String.join((CharSequence)", ", Arrays.stream(columns).collect(Collectors.toList()));
            return this;
        }

        public String toPrettyString() {
            return this.toPrettyString(true);
        }

        public String toPrettyString(boolean prettyPrint) {
            StringBuilder sql = new StringBuilder("select ");
            if (this.distinct) {
                sql.append("distinct ");
            }
            sql.append(this.columns);
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(SqlKeyword.FROM + this.from);
            if (this.where != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.WHERE + this.where);
            }
            if (this.groupBy != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.GROUP_BY + this.groupBy);
            }
            if (this.having != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.HAVING + this.having);
            }
            if (this.orderBy != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.ORDER_BY + this.orderBy);
            }
            if (this.limit != null) {
                sql.append(prettyPrint ? System.lineSeparator() : "");
                sql.append(SqlKeyword.LIMIT + this.limit);
            }
            return sql.toString();
        }

        public String toString() {
            return this.toPrettyString(false);
        }

        public Builder where(ConditionSql condition) {
            this.where(condition.toString());
            return this;
        }

        public Builder where(String expr) {
            this.where = expr;
            return this;
        }
    }
}

