/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.table.orm;

import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.common.handler.ConsumerHandler;
import org.nkjmlab.sorm4j.common.handler.FunctionHandler;
import org.nkjmlab.sorm4j.internal.table.orm.SimpleTable;
import org.nkjmlab.sorm4j.table.orm.TableConnection;
import org.nkjmlab.sorm4j.table.orm.TableOrm;
import org.nkjmlab.sorm4j.util.function.exception.Try;

public interface Table<T>
extends TableOrm<T> {
    @Override
    public Sorm getOrm();

    public static <T> Table<T> of(Sorm orm, Class<T> valueType) {
        return new SimpleTable<T>(orm, valueType);
    }

    public static <T> Table<T> of(Sorm orm, Class<T> valueType, String tableName) {
        return new SimpleTable<T>(orm, valueType, tableName);
    }

    default public TableConnection<T> toTableConnection(OrmConnection conn) {
        return TableConnection.of(conn, this.getValueType(), this.getTableName());
    }

    default public TableConnection<T> open() {
        return TableConnection.of(this.getOrm().open(), this.getValueType(), this.getTableName());
    }

    default public void acceptHandler(ConsumerHandler<TableConnection<T>> handler) {
        try (TableConnection<T> conn = this.open();){
            handler.accept(conn);
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R> R applyHandler(FunctionHandler<TableConnection<T>, R> handler) {
        try (TableConnection<T> conn = this.open();){
            R r = handler.apply(conn);
            return r;
        }
        catch (Exception e) {
            throw Try.rethrow(e);
        }
    }
}

