/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.CommandChineseWhispers;
import org.nlpub.watset.cli.CommandGraph;
import org.nlpub.watset.cli.CommandMarkovClustering;
import org.nlpub.watset.cli.CommandMaxMax;
import org.nlpub.watset.cli.CommandSenses;
import org.nlpub.watset.cli.CommandTrivial;
import org.nlpub.watset.cli.CommandWatset;
import org.nlpub.watset.cli.PathConverter;
import org.nlpub.watset.util.ABCFormat;

public class Application {
    private static final Logger logger = Logger.getLogger(Application.class.getSimpleName());
    private static final IDefaultProvider DEFAULT_PROVIDER = option -> {
        switch (option.toLowerCase(Locale.ROOT)) {
            case "--input": {
                return "/dev/stdin";
            }
            case "--output": {
                return "/dev/stdout";
            }
        }
        return null;
    };
    @Parameter(names={"-i", "--input"}, description="Input file", converter=PathConverter.class)
    public Path input;
    @Parameter(names={"-o", "--output"}, description="Output file", converter=PathConverter.class)
    public Path output;

    public Graph<String, DefaultWeightedEdge> getGraph() {
        Graph<String, DefaultWeightedEdge> graph;
        block8: {
            Stream<String> stream = Files.lines(this.input);
            try {
                Graph<String, DefaultWeightedEdge> graph2 = ABCFormat.parse(stream);
                logger.log(Level.INFO, "Read {0} nodes and {1} edges from {2}.", new Object[]{graph2.vertexSet().size(), graph2.edgeSet().size(), this.input.toAbsolutePath()});
                graph = graph2;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return graph;
    }

    public static void main(String[] args) {
        Application application = new Application();
        CommandTrivial empty = new CommandTrivial(application, "empty");
        CommandTrivial singleton = new CommandTrivial(application, "singleton");
        CommandTrivial together = new CommandTrivial(application, "together");
        CommandTrivial components = new CommandTrivial(application, "components");
        CommandChineseWhispers cw = new CommandChineseWhispers(application);
        CommandMarkovClustering mcl = new CommandMarkovClustering(application, false);
        CommandMarkovClustering mclBin = new CommandMarkovClustering(application, true);
        CommandSenses senses = new CommandSenses(application);
        CommandGraph graph = new CommandGraph(application);
        CommandWatset watset = new CommandWatset(application);
        CommandMaxMax maxmax = new CommandMaxMax(application);
        JCommander jc = JCommander.newBuilder().addObject((Object)application).addCommand("empty", (Object)empty, new String[0]).addCommand("singleton", (Object)singleton, new String[0]).addCommand("together", (Object)together, new String[0]).addCommand("components", (Object)components, new String[0]).addCommand("cw", (Object)cw, new String[0]).addCommand("mcl", (Object)mcl, new String[0]).addCommand("mcl-bin", (Object)mclBin, new String[0]).addCommand("senses", (Object)senses, new String[0]).addCommand("graph", (Object)graph, new String[0]).addCommand("watset", (Object)watset, new String[0]).addCommand("maxmax", (Object)maxmax, new String[0]).defaultProvider(DEFAULT_PROVIDER).build();
        jc.parse(args);
        if (Objects.isNull(jc.getParsedCommand())) {
            System.err.println("Please read the documentation.");
            System.exit(1);
        }
        switch (jc.getParsedCommand().toLowerCase(Locale.ROOT)) {
            case "empty": {
                empty.run();
                break;
            }
            case "singleton": {
                singleton.run();
                break;
            }
            case "together": {
                together.run();
                break;
            }
            case "components": {
                components.run();
                break;
            }
            case "cw": {
                cw.run();
                break;
            }
            case "mcl": {
                mcl.run();
                break;
            }
            case "mcl-bin": {
                mclBin.run();
                break;
            }
            case "senses": {
                senses.run();
                break;
            }
            case "graph": {
                graph.run();
                break;
            }
            case "watset": {
                watset.run();
                break;
            }
            case "maxmax": {
                maxmax.run();
                break;
            }
        }
    }
}

