/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Application;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.cli.PathConverter;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.util.AlgorithmProvider;

class CommandMarkovClustering
extends ClusteringCommand {
    private final boolean binary;
    @Parameter(names={"-e"})
    private Integer e;
    @Parameter(names={"-r"})
    private Double r;
    @Parameter(names={"--bin"}, converter=PathConverter.class)
    private Path binaryPath;

    public CommandMarkovClustering(Application application, boolean binary) {
        super(application);
        this.binary = binary;
    }

    @Override
    public Clustering<String> getClustering() {
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                if (Objects.nonNull(CommandMarkovClustering.this.e)) {
                    this.put("e", Integer.toString(CommandMarkovClustering.this.e));
                }
                if (Objects.nonNull(CommandMarkovClustering.this.r)) {
                    this.put("r", Double.toString(CommandMarkovClustering.this.r));
                }
                if (Objects.nonNull(CommandMarkovClustering.this.binaryPath)) {
                    this.put("bin", CommandMarkovClustering.this.binaryPath.toAbsolutePath().toString());
                }
            }
        };
        AlgorithmProvider<String, DefaultWeightedEdge> algorithm = new AlgorithmProvider<String, DefaultWeightedEdge>(this.binary ? "mcl-bin" : "mcl", (Map<String, String>)params);
        return algorithm.apply(this.application.getGraph());
    }
}

