/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.eval;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.Clustering;

public class Measurer<V, E> {
    private static final Logger logger = Logger.getLogger(Measurer.class.getSimpleName());
    public static final int REPETITIONS = 10;
    public static final int WARMUP = 5;
    private final Function<Graph<V, E>, Clustering<V>> provider;
    private final int repetitions;
    private final int warmup;
    private final Graph<V, E> graph;
    private long[] durations;
    private int[] clusters;

    public Measurer(Function<Graph<V, E>, Clustering<V>> provider, Graph<V, E> graph, int repetitions, int warmup) {
        this.provider = provider;
        this.repetitions = repetitions;
        this.warmup = warmup;
        this.graph = graph;
    }

    public Measurer(Function<Graph<V, E>, Clustering<V>> provider, Graph<V, E> graph) {
        this(provider, graph, 10, 5);
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public List<Long> getDurations() {
        return Arrays.stream(this.durations).boxed().collect(Collectors.toList());
    }

    public List<Integer> getClusters() {
        return Arrays.stream(this.clusters).boxed().collect(Collectors.toList());
    }

    public void run() {
        System.gc();
        logger.log(Level.INFO, "Evaluating a graph with {0} node(s).", this.graph.vertexSet().size());
        this.durations = new long[this.repetitions];
        this.clusters = new int[this.repetitions];
        for (int i = -this.warmup; i < this.repetitions; ++i) {
            Clustering<V> clustering = this.provider.apply(this.graph);
            Duration duration = this.measure(clustering);
            if (i < 0) continue;
            this.durations[i] = duration.toMillis();
            this.clusters[i] = clustering.getClusters().size();
        }
        logger.info("Evaluation complete.");
    }

    private Duration measure(Clustering<V> clustering) {
        Instant start = Instant.now();
        clustering.fit();
        Instant end = Instant.now();
        return Duration.between(start, end);
    }
}

