/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.Clustering;

public class MarkovClustering<V, E>
implements Clustering<V> {
    public static final Integer ITERATIONS = 20;
    protected final Graph<V, E> graph;
    protected final int e;
    protected final double r;
    protected final InflateVisitor inflateVisitor;
    protected RealMatrix matrix;
    protected RealMatrix ones;
    protected Map<V, Integer> index;

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider(int e, double r) {
        return graph -> new MarkovClustering(graph, e, r);
    }

    public MarkovClustering(Graph<V, E> graph, int e, double r) {
        this.graph = Objects.requireNonNull(graph);
        this.e = e;
        this.r = r;
        this.inflateVisitor = new InflateVisitor();
    }

    @Override
    public void fit() {
        this.index = null;
        this.matrix = null;
        this.ones = null;
        if (this.graph.vertexSet().isEmpty()) {
            return;
        }
        this.index = this.buildIndex();
        this.matrix = this.buildMatrix(this.index);
        double[] onesData = new double[this.matrix.getRowDimension()];
        Arrays.fill(onesData, 1.0);
        this.ones = MatrixUtils.createRowRealMatrix((double[])onesData);
        this.normalize();
        for (int i = 0; i < ITERATIONS; ++i) {
            RealMatrix previous = this.matrix.copy();
            this.expand();
            this.inflate();
            if (this.matrix.equals(previous)) break;
        }
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        Objects.requireNonNull(this.index, "call fit() first");
        Objects.requireNonNull(this.matrix, "call fit() first");
        if (this.graph.vertexSet().isEmpty()) {
            return Collections.emptySet();
        }
        Map<Integer, Object> inverted = this.index.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        HashSet<Collection<V>> clusters = new HashSet<Collection<V>>();
        for (int r = 0; r < this.matrix.getRowDimension(); ++r) {
            HashSet<Object> cluster = new HashSet<Object>();
            for (int c = 0; c < this.matrix.getColumnDimension(); ++c) {
                if (!(this.matrix.getEntry(r, c) > 0.0)) continue;
                cluster.add(inverted.get(c));
            }
            if (cluster.isEmpty()) continue;
            clusters.add(cluster);
        }
        return clusters;
    }

    protected Map<V, Integer> buildIndex() {
        HashMap index = new HashMap();
        int i = 0;
        for (Object vertex : this.graph.vertexSet()) {
            index.put(vertex, i++);
        }
        return index;
    }

    protected RealMatrix buildMatrix(Map<V, Integer> index) {
        RealMatrix matrix = MatrixUtils.createRealIdentityMatrix((int)this.graph.vertexSet().size());
        for (Object edge : this.graph.edgeSet()) {
            int j;
            int i = index.get(this.graph.getEdgeSource(edge));
            if (i == (j = index.get(this.graph.getEdgeTarget(edge)).intValue())) continue;
            double weight = this.graph.getEdgeWeight(edge);
            matrix.setEntry(i, j, weight);
            matrix.setEntry(j, i, weight);
        }
        return matrix;
    }

    protected void normalize() {
        RealMatrix sums = this.ones.multiply(this.matrix);
        this.matrix.walkInOptimizedOrder((RealMatrixChangingVisitor)new NormalizeVisitor(sums));
    }

    protected void expand() {
        this.matrix = this.matrix.power(this.e);
    }

    protected void inflate() {
        this.normalize();
        this.matrix.walkInOptimizedOrder((RealMatrixChangingVisitor)this.inflateVisitor);
    }

    public static class NormalizeVisitor
    extends DefaultRealMatrixChangingVisitor {
        private final RealMatrix sums;

        public NormalizeVisitor(RealMatrix sums) {
            this.sums = sums;
        }

        public double visit(int row, int column, double value) {
            return value / this.sums.getEntry(0, column);
        }
    }

    public class InflateVisitor
    extends DefaultRealMatrixChangingVisitor {
        private InflateVisitor() {
        }

        public double visit(int row, int column, double value) {
            return StrictMath.pow(value, MarkovClustering.this.r);
        }
    }
}

