/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.AlgorithmProvider;
import org.nlpub.watset.util.CosineContextSimilarity;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

@Parameters(commandDescription="Sense Graph")
class GraphCommand
extends Command {
    @Parameter(required=true, description="Local clustering algorithm", names={"-l", "--local"})
    private String local;
    @DynamicParameter(description="Local clustering algorithm parameters", names={"-lp", "--local-params"})
    private Map<String, String> localParams = new HashMap<String, String>();
    @Parameter(description="Use Simplified Watset", names={"-s", "--simplified"})
    private boolean simplified = false;

    GraphCommand() {
    }

    @Override
    public void run() {
        AlgorithmProvider<String, DefaultWeightedEdge> localProvider = new AlgorithmProvider<String, DefaultWeightedEdge>(this.local, this.localParams);
        Graph<String, DefaultWeightedEdge> graph = this.getGraph();
        Graph<Sense<String>, DefaultWeightedEdge> senseGraph = this.simplified ? this.getSimplifiedWatsetGraph(graph, localProvider) : this.getWatsetGraph(graph, localProvider);
        try {
            this.write(senseGraph);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(Graph<Sense<String>, DefaultWeightedEdge> graph) throws IOException {
        try (BufferedWriter writer = this.newOutputWriter();){
            for (DefaultWeightedEdge edge : graph.edgeSet()) {
                IndexedSense source = (IndexedSense)graph.getEdgeSource((Object)edge);
                IndexedSense target = (IndexedSense)graph.getEdgeTarget((Object)edge);
                writer.write(String.format(Locale.ROOT, "%s#%d\t%s#%d\t%f%n", source.get(), source.getSense(), target.get(), target.getSense(), graph.getEdgeWeight((Object)edge)));
            }
        }
    }

    private Graph<Sense<String>, DefaultWeightedEdge> getWatsetGraph(Graph<String, DefaultWeightedEdge> graph, AlgorithmProvider<String, DefaultWeightedEdge> localProvider) {
        Watset<String, DefaultWeightedEdge> watset = new Watset<String, DefaultWeightedEdge>(graph, localProvider, EmptyClustering.provider(), new CosineContextSimilarity());
        watset.fit();
        return watset.getSenseGraph();
    }

    private Graph<Sense<String>, DefaultWeightedEdge> getSimplifiedWatsetGraph(Graph<String, DefaultWeightedEdge> graph, AlgorithmProvider<String, DefaultWeightedEdge> localProvider) {
        SimplifiedWatset<String, DefaultWeightedEdge> watset = new SimplifiedWatset<String, DefaultWeightedEdge>(graph, localProvider, EmptyClustering.provider());
        watset.fit();
        return watset.getSenseGraph();
    }
}

