/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.cli.PathConverter;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.util.AlgorithmProvider;

class MarkovClusteringCommand
extends ClusteringCommand {
    private final boolean binary;
    @Parameter(names={"-e"})
    private Integer e;
    @Parameter(names={"-r"})
    private Double r;
    @Parameter(names={"--bin"}, converter=PathConverter.class)
    private Path binaryPath;

    public MarkovClusteringCommand(boolean binary) {
        this.binary = binary;
    }

    @Override
    public Clustering<String> getClustering() {
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                if (Objects.nonNull(MarkovClusteringCommand.this.e)) {
                    this.put("e", Integer.toString(MarkovClusteringCommand.this.e));
                }
                if (Objects.nonNull(MarkovClusteringCommand.this.r)) {
                    this.put("r", Double.toString(MarkovClusteringCommand.this.r));
                }
                if (Objects.nonNull(MarkovClusteringCommand.this.binaryPath)) {
                    this.put("bin", MarkovClusteringCommand.this.binaryPath.toAbsolutePath().toString());
                }
            }
        };
        AlgorithmProvider<String, DefaultWeightedEdge> algorithm = new AlgorithmProvider<String, DefaultWeightedEdge>(this.binary ? "mcl-bin" : "mcl", (Map<String, String>)params);
        return algorithm.apply(this.getGraph());
    }
}

