/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.AlgorithmProvider;
import org.nlpub.watset.util.CosineContextSimilarity;

@Parameters(commandDescription="Watset")
class WatsetCommand
extends ClusteringCommand {
    @Parameter(required=true, description="Local clustering algorithm", names={"-l", "--local"})
    private String local;
    @DynamicParameter(description="Local clustering algorithm parameters", names={"-lp", "--local-params"})
    private Map<String, String> localParams = new HashMap<String, String>();
    @Parameter(required=true, description="Global clustering algorithm", names={"-g", "--global"})
    private String global;
    @DynamicParameter(description="Global clustering algorithm parameters", names={"-gp", "--global-params"})
    private Map<String, String> globalParams = new HashMap<String, String>();
    @Parameter(description="Use Simplified Watset", names={"-s", "--simplified"})
    private boolean simplified = false;

    WatsetCommand() {
    }

    @Override
    public Clustering<String> getClustering() {
        AlgorithmProvider localProvider = new AlgorithmProvider(this.local, this.localParams);
        AlgorithmProvider globalProvider = new AlgorithmProvider(this.global, this.globalParams);
        Graph<String, DefaultWeightedEdge> graph = this.getGraph();
        if (this.simplified) {
            return new SimplifiedWatset<String, DefaultWeightedEdge>(graph, localProvider, globalProvider);
        }
        Watset<String, DefaultWeightedEdge> watset = new Watset<String, DefaultWeightedEdge>(graph, localProvider, globalProvider, new CosineContextSimilarity());
        return watset;
    }
}

