/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.ChineseWhispers;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.ComponentsClustering;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.MarkovClustering;
import org.nlpub.watset.graph.MarkovClusteringBinaryRunner;
import org.nlpub.watset.graph.MaxMax;
import org.nlpub.watset.graph.NodeWeighting;
import org.nlpub.watset.graph.SingletonClustering;
import org.nlpub.watset.graph.TogetherClustering;

public class AlgorithmProvider<V, E>
implements Function<Graph<V, E>, Clustering<V>> {
    private static final Logger logger = Logger.getLogger(AlgorithmProvider.class.getSimpleName());
    private final String algorithm;
    private final Map<String, String> params;
    private final NodeWeighting<V, E> weighting;

    public AlgorithmProvider(String algorithm) {
        this(algorithm, null);
    }

    public AlgorithmProvider(String algorithm, Map<String, String> params) {
        this.algorithm = Objects.requireNonNull(algorithm);
        this.params = Objects.isNull(params) ? Collections.emptyMap() : params;
        this.weighting = this.parseChineseWhispersNodeWeighting();
    }

    @Override
    public Clustering<V> apply(Graph<V, E> graph) {
        switch (this.algorithm.toLowerCase(Locale.ROOT)) {
            case "empty": {
                return new EmptyClustering();
            }
            case "together": {
                return new TogetherClustering<V, E>(graph);
            }
            case "singleton": {
                return new SingletonClustering<V, E>(graph);
            }
            case "components": {
                return new ComponentsClustering<V, E>(graph);
            }
            case "cw": {
                return new ChineseWhispers<V, E>(graph, this.weighting);
            }
            case "mcl": 
            case "mcl-bin": {
                int e = Integer.parseInt(this.params.getOrDefault("e", "2"));
                double r = Double.parseDouble(this.params.getOrDefault("r", "2"));
                if (this.algorithm.equalsIgnoreCase("mcl")) {
                    return new MarkovClustering<V, E>(graph, e, r);
                }
                return new MarkovClusteringBinaryRunner<V, E>(graph, Paths.get(this.params.get("bin"), new String[0]), r, Runtime.getRuntime().availableProcessors());
            }
            case "maxmax": {
                return new MaxMax<V, E>(graph);
            }
        }
        throw new IllegalArgumentException("Unknown algorithm is set.");
    }

    private NodeWeighting<V, E> parseChineseWhispersNodeWeighting() {
        switch (this.params.getOrDefault("mode", "top").toLowerCase(Locale.ROOT)) {
            case "label": {
                return NodeWeighting.label();
            }
            case "top": {
                return NodeWeighting.top();
            }
            case "log": {
                return NodeWeighting.log();
            }
            case "nolog": {
                logger.warning("Please update your code: 'nolog' weighting is renamed to 'lin'.");
            }
            case "lin": {
                return NodeWeighting.linear();
            }
        }
        throw new IllegalArgumentException("Unknown mode is set.");
    }
}

