/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Locale;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.AlgorithmProvider;
import org.nlpub.watset.util.CosineContextSimilarity;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

@Parameters(commandDescription="Sense Graph")
class GraphCommand
extends Command {
    @ParametersDelegate
    public Command.LocalParameters local = new Command.LocalParameters();

    public GraphCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        AlgorithmProvider<String, DefaultWeightedEdge> algorithm = new AlgorithmProvider<String, DefaultWeightedEdge>(this.local.algorithm, this.local.params);
        Graph<String, DefaultWeightedEdge> graph = this.getGraph();
        Graph<Sense<String>, DefaultWeightedEdge> senseGraph = this.local.simplified ? this.getSimplifiedWatsetGraph(graph, algorithm) : this.getWatsetGraph(graph, algorithm);
        try {
            this.write(senseGraph);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(Graph<Sense<String>, DefaultWeightedEdge> graph) throws IOException {
        try (BufferedWriter writer = this.newOutputWriter();){
            for (DefaultWeightedEdge edge : graph.edgeSet()) {
                IndexedSense source = (IndexedSense)graph.getEdgeSource((Object)edge);
                IndexedSense target = (IndexedSense)graph.getEdgeTarget((Object)edge);
                writer.write(String.format(Locale.ROOT, "%s#%d\t%s#%d\t%f%n", source.get(), source.getSense(), target.get(), target.getSense(), graph.getEdgeWeight((Object)edge)));
            }
        }
    }

    private Graph<Sense<String>, DefaultWeightedEdge> getWatsetGraph(Graph<String, DefaultWeightedEdge> graph, AlgorithmProvider<String, DefaultWeightedEdge> localProvider) {
        Watset<String, DefaultWeightedEdge> watset = new Watset<String, DefaultWeightedEdge>(graph, localProvider, EmptyClustering.provider(), new CosineContextSimilarity());
        watset.fit();
        return watset.getSenseGraph();
    }

    private Graph<Sense<String>, DefaultWeightedEdge> getSimplifiedWatsetGraph(Graph<String, DefaultWeightedEdge> graph, AlgorithmProvider<String, DefaultWeightedEdge> localProvider) {
        SimplifiedWatset<String, DefaultWeightedEdge> watset = new SimplifiedWatset<String, DefaultWeightedEdge>(graph, localProvider, EmptyClustering.provider());
        watset.fit();
        return watset.getSenseGraph();
    }
}

