/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.MarkovClusteringCommand;
import org.nlpub.watset.cli.PathConverter;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.util.AlgorithmProvider;

@Parameters(commandDescription="Markov Clustering Official Binary")
public class MarkovClusteringOfficialCommand
extends MarkovClusteringCommand {
    @Parameter(description="Path to binary mcl", names={"--bin"}, converter=PathConverter.class)
    private Path binary;

    public MarkovClusteringOfficialCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public Clustering<String> getClustering() {
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                if (Objects.nonNull(MarkovClusteringOfficialCommand.this.e)) {
                    this.put("e", Integer.toString(MarkovClusteringOfficialCommand.this.e));
                }
                if (Objects.nonNull(MarkovClusteringOfficialCommand.this.r)) {
                    this.put("r", Double.toString(MarkovClusteringOfficialCommand.this.r));
                }
                if (Objects.nonNull(MarkovClusteringOfficialCommand.this.binary)) {
                    this.put("bin", MarkovClusteringOfficialCommand.this.binary.toAbsolutePath().toString());
                }
            }
        };
        AlgorithmProvider<String, DefaultWeightedEdge> algorithm = new AlgorithmProvider<String, DefaultWeightedEdge>("mcl-bin", (Map<String, String>)params);
        return algorithm.apply(this.getGraph());
    }
}

