/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.AlgorithmProvider;
import org.nlpub.watset.util.CosineContextSimilarity;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

@Parameters(commandDescription="Sense Induction")
class SensesCommand
extends Command {
    @ParametersDelegate
    public Command.LocalParameters local = new Command.LocalParameters();

    public SensesCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        AlgorithmProvider<String, DefaultWeightedEdge> algorithm = new AlgorithmProvider<String, DefaultWeightedEdge>(this.local.algorithm, this.local.params);
        Graph<String, DefaultWeightedEdge> graph = this.getGraph();
        Map<Sense<String>, Map<Sense<String>, Number>> contexts = this.local.simplified ? this.getSimplifiedWatsetContexts(algorithm, graph) : this.getWatsetContexts(algorithm, graph);
        try {
            this.write(contexts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void write(Map<Sense<String>, Map<Sense<String>, Number>> contexts) throws IOException {
        try (BufferedWriter writer = this.newOutputWriter();){
            for (Map.Entry<Sense<String>, Map<Sense<String>, Number>> context : contexts.entrySet()) {
                IndexedSense sense = (IndexedSense)context.getKey();
                String contextRecord = context.getValue().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s#%d:%f", ((Sense)e.getKey()).get(), ((IndexedSense)e.getKey()).getSense(), ((Number)e.getValue()).doubleValue())).collect(Collectors.joining(","));
                writer.write(String.format(Locale.ROOT, "%s\t%d\t%s%n", sense.get(), sense.getSense(), contextRecord));
            }
        }
    }

    public Map<Sense<String>, Map<Sense<String>, Number>> getWatsetContexts(AlgorithmProvider<String, DefaultWeightedEdge> algorithm, Graph<String, DefaultWeightedEdge> graph) {
        Watset<String, DefaultWeightedEdge> watset = new Watset<String, DefaultWeightedEdge>(graph, algorithm, EmptyClustering.provider(), new CosineContextSimilarity());
        watset.fit();
        return watset.getContexts();
    }

    public Map<Sense<String>, Map<Sense<String>, Number>> getSimplifiedWatsetContexts(AlgorithmProvider<String, DefaultWeightedEdge> algorithm, Graph<String, DefaultWeightedEdge> graph) {
        SimplifiedWatset<String, DefaultWeightedEdge> watset = new SimplifiedWatset<String, DefaultWeightedEdge>(graph, algorithm, EmptyClustering.provider());
        watset.fit();
        return watset.getContexts();
    }
}

