/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.AlgorithmProvider;
import org.nlpub.watset.util.CosineContextSimilarity;

@Parameters(commandDescription="Watset")
class WatsetCommand
extends ClusteringCommand {
    @ParametersDelegate
    public Command.LocalParameters local = new Command.LocalParameters();
    @ParametersDelegate
    public Command.GlobalParameters global = new Command.GlobalParameters();

    public WatsetCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public Clustering<String> getClustering() {
        AlgorithmProvider localAlgorithm = new AlgorithmProvider(this.local.algorithm, this.local.params);
        AlgorithmProvider globalAlgorithm = new AlgorithmProvider(this.global.algorithm, this.global.params);
        Graph<String, DefaultWeightedEdge> graph = this.getGraph();
        if (this.local.simplified) {
            return new SimplifiedWatset<String, DefaultWeightedEdge>(graph, localAlgorithm, globalAlgorithm);
        }
        Watset<String, DefaultWeightedEdge> watset = new Watset<String, DefaultWeightedEdge>(graph, localAlgorithm, globalAlgorithm, new CosineContextSimilarity());
        return watset;
    }
}

