/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.graph.AsUnmodifiableGraph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.builder.GraphBuilder;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.SenseInduction;
import org.nlpub.watset.util.ContextSimilarity;
import org.nlpub.watset.util.CosineContextSimilarity;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

@Deprecated
public class Watset<V, E>
implements Clustering<V> {
    private static final Number DEFAULT_CONTEXT_WEIGHT = 1;
    private static final Logger logger = Logger.getLogger(Watset.class.getSimpleName());
    private final Graph<V, E> graph;
    private final Function<Graph<Sense<V>, DefaultWeightedEdge>, Clustering<Sense<V>>> global;
    private final ContextSimilarity<V> similarity;
    private final SenseInduction<V, E> inducer;
    private Map<V, Map<Sense<V>, Map<V, Number>>> inventory;
    private Map<Sense<V>, Map<Sense<V>, Number>> contexts;
    private Collection<Collection<Sense<V>>> senseClusters;
    private Graph<Sense<V>, DefaultWeightedEdge> senseGraph;

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider(Function<Graph<V, E>, Clustering<V>> local, Function<Graph<Sense<V>, DefaultWeightedEdge>, Clustering<Sense<V>>> global) {
        return graph -> new Watset(graph, local, global, new CosineContextSimilarity());
    }

    public Watset(Graph<V, E> graph, Function<Graph<V, E>, Clustering<V>> local, Function<Graph<Sense<V>, DefaultWeightedEdge>, Clustering<Sense<V>>> global, ContextSimilarity<V> similarity) {
        this.graph = Objects.requireNonNull(graph);
        this.global = Objects.requireNonNull(global);
        this.similarity = Objects.requireNonNull(similarity);
        this.inducer = new SenseInduction<V, E>(graph, Objects.requireNonNull(local));
    }

    @Override
    public void fit() {
        this.senseClusters = null;
        this.senseGraph = null;
        this.inventory = null;
        this.contexts = null;
        logger.info("Watset started.");
        this.inventory = new ConcurrentHashMap<V, Map<Sense<V>, Map<V, Number>>>();
        this.graph.vertexSet().parallelStream().forEach(node -> {
            List<Map<Object, Number>> senses = this.inducer.contexts(node);
            HashMap<IndexedSense<Object>, Map<Object, Number>> senseMap = new HashMap<IndexedSense<Object>, Map<Object, Number>>(senses.size());
            for (int i = 0; i < senses.size(); ++i) {
                senseMap.put(new IndexedSense<Object>(node, i), senses.get(i));
            }
            this.inventory.put(node, senseMap);
        });
        int senses = this.inventory.values().stream().mapToInt(Map::size).sum();
        logger.log(Level.INFO, "Watset: sense inventory constructed including {0} senses.", senses);
        this.contexts = new ConcurrentHashMap<Sense<V>, Map<Sense<V>, Number>>(senses);
        this.inventory.entrySet().parallelStream().forEach(wordSenses -> {
            if (((Map)wordSenses.getValue()).isEmpty()) {
                this.contexts.put(new IndexedSense(wordSenses.getKey(), 0), Collections.emptyMap());
            } else {
                ((Map)wordSenses.getValue()).forEach((sense, context) -> this.contexts.put((Sense<Map<Sense<V>, Number>>)sense, (Map<Sense<Map<Sense<V>, Number>>, Number>)this.disambiguateContext(this.inventory, (Sense<V>)sense)));
            }
        });
        logger.info("Watset: contexts constructed.");
        this.senseGraph = this.buildSenseGraph(this.contexts);
        if (this.graph.edgeSet().size() > this.senseGraph.edgeSet().size()) {
            throw new IllegalStateException("Mismatch in number of edges: expected at least " + this.graph.edgeSet().size() + ", but got " + this.senseGraph.edgeSet().size());
        }
        logger.info("Watset: sense graph constructed.");
        Clustering<Sense<V>> globalClustering = this.global.apply(this.senseGraph);
        globalClustering.fit();
        logger.info("Watset: extracting sense clusters.");
        this.senseClusters = globalClustering.getClusters();
        logger.info("Watset finished.");
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        return Objects.requireNonNull(this.senseClusters, "call fit() first").stream().map(cluster -> cluster.stream().map(Supplier::get).collect(Collectors.toSet())).collect(Collectors.toSet());
    }

    public Map<V, Map<Sense<V>, Map<V, Number>>> getInventory() {
        return Collections.unmodifiableMap(Objects.requireNonNull(this.inventory, "call fit() first"));
    }

    public Map<Sense<V>, Map<Sense<V>, Number>> getContexts() {
        return Collections.unmodifiableMap(Objects.requireNonNull(this.contexts, "call fit() first"));
    }

    public Graph<Sense<V>, DefaultWeightedEdge> getSenseGraph() {
        return new AsUnmodifiableGraph(Objects.requireNonNull(this.senseGraph, "call fit() first"));
    }

    private Map<Sense<V>, Number> disambiguateContext(Map<V, Map<Sense<V>, Map<V, Number>>> inventory, Sense<V> sense) {
        HashMap<Number, Number> context = new HashMap<Number, Number>(inventory.get(sense.get()).get(sense));
        context.put((Number)sense.get(), DEFAULT_CONTEXT_WEIGHT);
        return Sense.disambiguate(inventory, this.similarity, context, Collections.singleton(sense.get()));
    }

    private Graph<Sense<V>, DefaultWeightedEdge> buildSenseGraph(Map<Sense<V>, Map<Sense<V>, Number>> contexts) {
        GraphBuilder builder = SimpleWeightedGraph.createBuilder(DefaultWeightedEdge.class);
        contexts.keySet().forEach(arg_0 -> ((GraphBuilder)builder).addVertex(arg_0));
        contexts.forEach((source, context) -> context.forEach((target, weight) -> builder.addEdge(source, target, weight.doubleValue())));
        return builder.build();
    }
}

