/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.util.ILEFormat;

abstract class ClusteringCommand
extends Command {
    public ClusteringCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        Clustering<String> clustering = this.getClustering();
        clustering.fit();
        try (BufferedWriter writer = this.newOutputWriter();){
            ILEFormat.write(writer, clustering);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public abstract Clustering<String> getClustering();
}

