/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.nio.file.Path;
import java.util.Objects;
import org.jgrapht.Graph;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.cli.Command;
import org.nlpub.watset.cli.PathConverter;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.MarkovClusteringExternal;

@Parameters(commandDescription="Markov Clustering Official Binary")
class MarkovClusteringExternalCommand
extends ClusteringCommand {
    @Parameter(description="Inflation parameter", names={"-r"})
    private Double r;
    @Parameter(description="Path to binary mcl", names={"--bin"}, converter=PathConverter.class)
    private Path binary;

    public MarkovClusteringExternalCommand(Command.MainParameters parameters) {
        super(parameters);
    }

    @Override
    public Clustering<String> getClustering() {
        MarkovClusteringExternal.Builder builder = new MarkovClusteringExternal.Builder();
        if (Objects.nonNull(this.binary)) {
            builder.setPath(this.binary);
        }
        if (Objects.nonNull(this.r)) {
            builder.setR(this.r);
        }
        return builder.build((Graph)this.getGraph());
    }
}

