/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.ClusteringBuilder;

public class ComponentsClustering<V, E>
implements Clustering<V> {
    private final ConnectivityInspector<V, E> inspector;
    private Collection<Collection<V>> clusters;

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider() {
        return ComponentsClustering::new;
    }

    public ComponentsClustering(Graph<V, E> graph) {
        this.inspector = new ConnectivityInspector(Objects.requireNonNull(graph));
    }

    @Override
    public void fit() {
        this.clusters = this.inspector.connectedSets();
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        return Objects.requireNonNull(this.clusters, "call fit() first");
    }

    public static class Builder<V, E>
    implements ClusteringBuilder<V, E, ComponentsClustering<V, E>> {
        @Override
        public ComponentsClustering<V, E> build(Graph<V, E> graph) {
            return new ComponentsClustering<V, E>(graph);
        }

        @Override
        public Function<Graph<V, E>, Clustering<V>> provider() {
            return ComponentsClustering.provider();
        }
    }
}

