/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.ClusteringBuilder;

public class MarkovClusteringExternal<V, E>
implements Clustering<V> {
    private static final Logger logger = Logger.getLogger(MarkovClusteringExternal.class.getSimpleName());
    protected final Graph<V, E> graph;
    protected final Path path;
    protected final double r;
    protected final int threads;
    protected Map<V, Integer> mapping;
    protected File output;

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider(Path mcl, double r, int threads) {
        return graph -> new MarkovClusteringExternal(graph, mcl, r, threads);
    }

    @Deprecated
    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider(Path mcl, double r) {
        return graph -> new MarkovClusteringExternal(graph, mcl, r);
    }

    public MarkovClusteringExternal(Graph<V, E> graph, Path path, double r, int threads) {
        this.graph = Objects.requireNonNull(graph);
        this.path = Objects.requireNonNull(path);
        this.r = r;
        this.threads = threads;
    }

    @Deprecated
    public MarkovClusteringExternal(Graph<V, E> graph, Path path, double r) {
        this(graph, path, r, 1);
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        Collection collection;
        block8: {
            Objects.requireNonNull(this.mapping, "call fit() first");
            Objects.requireNonNull(this.output, "call fit() first");
            Map<Integer, Object> inverse = this.mapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            Stream<String> stream = Files.lines(this.output.toPath());
            try {
                collection = stream.map(line -> Arrays.stream(line.split("\t")).map(id -> inverse.get(Integer.valueOf(id))).collect(Collectors.toSet())).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Clusters cannot be read.", ex);
                }
            }
            stream.close();
        }
        return collection;
    }

    @Override
    public void fit() {
        logger.info("Preparing for Markov Clustering.");
        this.mapping = this.translate(this.graph);
        try {
            this.process();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        logger.info("Markov Clustering finished.");
    }

    private void process() throws IOException {
        this.output = File.createTempFile("mcl", "output");
        this.output.deleteOnExit();
        File input = this.writeInputFile();
        ProcessBuilder builder = new ProcessBuilder(this.path.toAbsolutePath().toString(), input.toString(), "-I", Double.toString(this.r), "-te", Integer.toString(this.threads), "--abc", "-o", this.output.toString());
        logger.info(() -> "Command: " + String.join((CharSequence)" ", builder.command()));
        Process process = builder.start();
        int status = 0;
        try {
            status = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(this.path.toAbsolutePath() + " has been interrupted", e);
        }
        if (status != 0) {
            InputStreamReader isr = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
            try {
                BufferedReader reader = new BufferedReader(isr);
                try {
                    String stderr = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                    if (stderr.isEmpty()) {
                        throw new IllegalStateException(this.path.toAbsolutePath() + " returned " + status);
                    }
                    throw new IllegalStateException(this.path.toAbsolutePath() + " returned " + status + ": " + stderr);
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)isr).close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private Map<V, Integer> translate(Graph<V, E> graph) {
        HashMap mapping = new HashMap(graph.vertexSet().size());
        int i = 0;
        for (Object node : graph.vertexSet()) {
            mapping.put(node, i++);
        }
        return mapping;
    }

    private File writeInputFile() throws IOException {
        File input = File.createTempFile("mcl", "input");
        input.deleteOnExit();
        try (BufferedWriter writer = Files.newBufferedWriter(input.toPath(), new OpenOption[0]);){
            for (Object edge : this.graph.edgeSet()) {
                int source = this.mapping.get(this.graph.getEdgeSource(edge));
                int target = this.mapping.get(this.graph.getEdgeTarget(edge));
                double weight = this.graph.getEdgeWeight(edge);
                writer.write(String.format(Locale.ROOT, "%d\t%d\t%f%n", source, target, weight));
            }
        }
        return input;
    }

    public static class Builder<V, E>
    implements ClusteringBuilder<V, E, MarkovClusteringExternal<V, E>> {
        public static final int R = 2;
        public static final int THREADS = 1;
        private Path path;
        private double r = 2.0;
        private int threads = 1;

        @Override
        public MarkovClusteringExternal<V, E> build(Graph<V, E> graph) {
            return new MarkovClusteringExternal<V, E>(graph, this.path, this.r, this.threads);
        }

        @Override
        public Function<Graph<V, E>, Clustering<V>> provider() {
            return MarkovClusteringExternal.provider(this.path, this.r, this.threads);
        }

        public Builder<V, E> setPath(Path path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder<V, E> setR(double r) {
            this.r = r;
            return this;
        }

        public Builder<V, E> setThreads(int threads) {
            this.threads = threads;
            return this;
        }
    }
}

