/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.ClusteringBuilder;

public class TogetherClustering<V, E>
implements Clustering<V> {
    private final Graph<V, E> graph;
    private Collection<Collection<V>> clusters;

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider() {
        return TogetherClustering::new;
    }

    public TogetherClustering(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph);
    }

    @Override
    public void fit() {
        this.clusters = Collections.singletonList(this.graph.vertexSet());
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        return Objects.requireNonNull(this.clusters, "call fit() first");
    }

    public static class Builder<V, E>
    implements ClusteringBuilder<V, E, TogetherClustering<V, E>> {
        @Override
        public TogetherClustering<V, E> build(Graph<V, E> graph) {
            return new TogetherClustering<V, E>(graph);
        }

        @Override
        public Function<Graph<V, E>, Clustering<V>> provider() {
            return TogetherClustering.provider();
        }
    }
}

