/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.graph.builder.GraphBuilder;

public final class ABCFormat {
    public static final String SEPARATOR = "\t";

    private ABCFormat() {
        throw new AssertionError();
    }

    public static Graph<String, DefaultWeightedEdge> parse(Stream<String> stream, String regex) {
        GraphBuilder builder = SimpleWeightedGraph.createBuilder(DefaultWeightedEdge.class);
        stream.forEach(line -> {
            String[] split = line.split(regex);
            if (split.length != 3 || split[0].equals(split[1])) {
                return;
            }
            builder.addVertices((Object[])new String[]{split[0], split[1]});
            builder.addEdge((Object)split[0], (Object)split[1], Double.parseDouble(split[2]));
        });
        return builder.build();
    }

    public static Graph<String, DefaultWeightedEdge> parse(Stream<String> stream) {
        return ABCFormat.parse(stream, SEPARATOR);
    }
}

