/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.util;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.ChineseWhispers;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.ComponentsClustering;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.MarkovClustering;
import org.nlpub.watset.graph.MarkovClusteringExternal;
import org.nlpub.watset.graph.MaxMax;
import org.nlpub.watset.graph.NodeWeighting;
import org.nlpub.watset.graph.NodeWeightings;
import org.nlpub.watset.graph.SingletonClustering;
import org.nlpub.watset.graph.TogetherClustering;

public class AlgorithmProvider<V, E>
implements Function<Graph<V, E>, Clustering<V>> {
    private static final Logger logger = Logger.getLogger(AlgorithmProvider.class.getSimpleName());
    private final String algorithm;
    private final Map<String, String> params;
    private final NodeWeighting<V, E> weighting;

    public AlgorithmProvider(String algorithm) {
        this(algorithm, null);
    }

    public AlgorithmProvider(String algorithm, Map<String, String> params) {
        this.algorithm = Objects.requireNonNull(algorithm, "algorithm is not specified");
        this.params = Objects.requireNonNullElse(params, Collections.emptyMap());
        this.weighting = this.parseChineseWhispersNodeWeighting();
    }

    @Override
    public Clustering<V> apply(Graph<V, E> graph) {
        switch (this.algorithm.toLowerCase(Locale.ROOT)) {
            case "empty": {
                return new EmptyClustering.Builder().build((Graph)graph);
            }
            case "together": {
                return new TogetherClustering.Builder().build((Graph)graph);
            }
            case "singleton": {
                return new SingletonClustering.Builder().build((Graph)graph);
            }
            case "components": {
                return new ComponentsClustering.Builder().build((Graph)graph);
            }
            case "cw": {
                return new ChineseWhispers.Builder<V, E>().setWeighting(this.weighting).build((Graph)graph);
            }
            case "mcl": {
                MarkovClustering.Builder mcl = new MarkovClustering.Builder();
                if (this.params.containsKey("e")) {
                    mcl.setE(Integer.parseInt(this.params.get("e")));
                }
                if (this.params.containsKey("r")) {
                    mcl.setR(Double.parseDouble(this.params.get("r")));
                }
                return mcl.build((Graph)graph);
            }
            case "mcl-bin": {
                MarkovClusteringExternal.Builder mclOfficial = new MarkovClusteringExternal.Builder().setPath(Path.of(this.params.get("bin"), new String[0])).setThreads(Runtime.getRuntime().availableProcessors());
                if (this.params.containsKey("r")) {
                    mclOfficial.setR(Double.parseDouble(this.params.get("r")));
                }
                return mclOfficial.build((Graph)graph);
            }
            case "maxmax": {
                return new MaxMax.Builder().build((Graph)graph);
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + this.algorithm);
    }

    private NodeWeighting<V, E> parseChineseWhispersNodeWeighting() {
        switch (this.params.getOrDefault("mode", "top").toLowerCase(Locale.ROOT)) {
            case "label": {
                return NodeWeightings.label();
            }
            case "top": {
                return NodeWeightings.top();
            }
            case "log": {
                return NodeWeightings.log();
            }
            case "nolog": {
                logger.warning("Please update your code: 'nolog' weighting is renamed to 'lin'.");
                return NodeWeightings.linear();
            }
            case "lin": {
                return NodeWeightings.linear();
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + this.params.get("mode"));
    }
}

